/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.etl.load.ETLRow;
import org.openvpms.etl.load.LoaderException;
import org.openvpms.etl.load.LoaderHelper;
import org.openvpms.etl.load.LookupData;
import org.openvpms.etl.load.LookupHandler;
import org.openvpms.etl.load.Mapping;
import org.openvpms.etl.load.Mappings;
import org.openvpms.etl.load.Node;
import org.openvpms.etl.load.NodeParser;
import org.openvpms.etl.load.ObjectHandler;
import org.openvpms.etl.load.SymbolicReference;
import org.openvpms.etl.load.SymbolicReferenceParser;

class RowMapper {
    private final Mappings mappings;
    private final ObjectHandler handler;
    private final LookupHandler lookupHandler;
    private final IArchetypeService service;
    private final Map<String, Node> nodes = new HashMap<String, Node>();
    private final Map<String, Map<String, NodeDescriptor>> descriptors = new HashMap<String, Map<String, NodeDescriptor>>();
    private final Map<String, org.openvpms.component.model.object.IMObject> objects = new LinkedHashMap<String, org.openvpms.component.model.object.IMObject>();
    private final Map<NodeDescriptor, LookupData> lookups = new HashMap<NodeDescriptor, LookupData>();
    private String rowId;

    public RowMapper(Mappings mappings, ObjectHandler handler, LookupHandler lookupHandler, IArchetypeService service) {
        this.mappings = mappings;
        this.handler = handler;
        this.service = service;
        for (Mapping mapping : mappings.getMapping()) {
            String target = mapping.getTarget();
            Node node = NodeParser.parse(target);
            if (node == null) {
                throw new LoaderException(LoaderException.ErrorCode.InvalidMapping, target);
            }
            this.nodes.put(target, node);
            while (node != null) {
                this.addDescriptor(node.getArchetype());
                node = node.getChild();
            }
        }
        this.lookupHandler = lookupHandler;
    }

    public List<org.openvpms.component.model.object.IMObject> map(ETLRow row) {
        this.objects.clear();
        this.lookups.clear();
        this.rowId = row.getRowId();
        for (Mapping mapping : this.mappings.getMapping()) {
            if (!row.exists(mapping.getSource())) {
                throw new LoaderException(LoaderException.ErrorCode.MissingRowValue, mapping.getSource());
            }
            Object value = row.get(mapping.getSource());
            if (mapping.getExcludeNull() && value == null) continue;
            this.mapValue(value, mapping, row);
        }
        if (this.lookupHandler != null && !this.lookups.isEmpty()) {
            this.lookupHandler.add(this.lookups);
        }
        ArrayList<org.openvpms.component.model.object.IMObject> result = new ArrayList<org.openvpms.component.model.object.IMObject>(this.objects.values());
        this.objects.clear();
        return result;
    }

    protected org.openvpms.component.model.object.IMObject create(Node node, Mapping mapping) {
        IMObject result = this.service.create(node.getArchetype());
        if (result == null) {
            throw new LoaderException(LoaderException.ErrorCode.ArchetypeNotFound, node.getArchetype());
        }
        if (mapping.getRemoveDefaultObjects()) {
            Map<String, NodeDescriptor> nodes = this.descriptors.get(node.getArchetype());
            for (NodeDescriptor nodeDesc : nodes.values()) {
                org.openvpms.component.model.object.IMObject[] children;
                if (!nodeDesc.isCollection()) continue;
                for (org.openvpms.component.model.object.IMObject child : children = nodeDesc.getChildren((org.openvpms.component.model.object.IMObject)result).toArray(new org.openvpms.component.model.object.IMObject[0])) {
                    nodeDesc.removeChildFromCollection(result, (Object)child);
                }
            }
        }
        return result;
    }

    private void addDescriptor(String shortName) {
        if (!this.descriptors.containsKey(shortName)) {
            ArchetypeDescriptor archetype = this.service.getArchetypeDescriptor(shortName);
            if (archetype == null) {
                throw new LoaderException(LoaderException.ErrorCode.ArchetypeNotFound, shortName);
            }
            HashMap<String, NodeDescriptor> map = new HashMap<String, NodeDescriptor>();
            for (NodeDescriptor descriptor : archetype.getAllNodeDescriptors()) {
                map.put(descriptor.getName(), descriptor);
            }
            this.descriptors.put(shortName, map);
        }
    }

    private void mapValue(Object value, Mapping mapping, ETLRow row) {
        Node node = this.nodes.get(mapping.getTarget());
        org.openvpms.component.model.object.IMObject object = this.getObject(node, null, null, mapping, row);
        while (node.getChild() != null) {
            Node parentNode = node;
            node = node.getChild();
            object = this.getObject(node, parentNode, object, mapping, row);
        }
        NodeDescriptor descriptor = this.getNode(node.getArchetype(), node.getName());
        if (descriptor.isObjectReference()) {
            String targetValue = this.getStringValue(value, mapping);
            descriptor.setValue(object, (Object)this.handler.getReference(targetValue));
        } else if (descriptor.isCollection()) {
            String targetValue = this.getStringValue(value, mapping);
            descriptor.addValue(object, (Object)this.handler.getObject(targetValue));
        } else if (this.lookupHandler != null && descriptor.isLookup() && this.lookupHandler.isGeneratedLookup(descriptor)) {
            LookupData lookup = this.getLookupValue(value, mapping);
            if (lookup != null) {
                descriptor.setValue(object, (Object)lookup.getCode());
                this.lookups.put(descriptor, lookup);
            }
        } else {
            Object targetValue = this.getValue(value, mapping);
            descriptor.setValue(object, targetValue);
        }
    }

    private org.openvpms.component.model.object.IMObject getObject(Node node, Node parentNode, org.openvpms.component.model.object.IMObject parent, Mapping mapping, ETLRow row) {
        org.openvpms.component.model.object.IMObject object = this.objects.get(node.getObjectPath());
        if (object == null) {
            int index;
            object = node.getField() != null ? this.getObject(node, row) : this.create(node, mapping);
            this.objects.put(node.getObjectPath(), object);
            int n = index = parent != null ? parentNode.getIndex() : -1;
            if (parent == null) {
                this.handler.add(this.rowId, object, index);
            } else {
                String name;
                IMObjectBean bean = this.service.getBean(parent);
                String archetype = parent.getArchetype();
                NodeDescriptor descriptor = this.getNode(archetype, name = parentNode.getName());
                if (descriptor.isCollection()) {
                    bean.addValue(name, object);
                } else if (descriptor.isObjectReference()) {
                    bean.setValue(parent.getName(), (Object)object.getObjectReference());
                    this.handler.add(this.rowId, object, index);
                } else {
                    bean.setValue(parent.getName(), (Object)object);
                }
            }
        }
        return object;
    }

    private org.openvpms.component.model.object.IMObject getObject(Node node, ETLRow row) {
        Object value = row.get(node.getField());
        if (value == null) {
            throw new LoaderException(LoaderException.ErrorCode.NullReference, node.getArchetype(), node.getField());
        }
        String ref = SymbolicReference.create(node.getArchetype(), value.toString());
        return this.handler.getObject(ref);
    }

    private Object getValue(Object object, Mapping mapping) {
        Object result;
        if (!StringUtils.isEmpty((CharSequence)mapping.getValue())) {
            String value = mapping.getValue();
            result = object != null ? LoaderHelper.replaceValue(value, object.toString()) : value;
        } else {
            result = object;
        }
        return result;
    }

    private String getStringValue(Object object, Mapping mapping) {
        Object result = this.getValue(object, mapping);
        return result != null ? result.toString() : null;
    }

    private LookupData getLookupValue(Object object, Mapping mapping) {
        String targetValue;
        LookupData result = null;
        String archetype = null;
        String mappingValue = mapping.getValue();
        if (mappingValue != null) {
            SymbolicReference reference = SymbolicReferenceParser.parse(mappingValue);
            if (reference != null) {
                targetValue = LoaderHelper.replaceValue(reference.getRowId(), object.toString());
                archetype = reference.getArchetype();
            } else {
                targetValue = this.getStringValue(object, mapping);
            }
        } else {
            targetValue = this.getStringValue(object, mapping);
        }
        if (targetValue != null) {
            String code = this.lookupHandler.getCode(targetValue);
            result = new LookupData(archetype, code, targetValue);
        }
        return result;
    }

    private NodeDescriptor getNode(String archetype, String name) {
        Map<String, NodeDescriptor> map = this.descriptors.get(archetype);
        return map.get(name);
    }
}

