/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.Collections;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.openvpms.etl.load.ETLLog;
import org.openvpms.etl.load.ETLLogDAO;

public class ETLLogDAOImpl
implements ETLLogDAO {
    private final SessionFactory factory;

    public ETLLogDAOImpl(SessionFactory factory) {
        this.factory = factory;
    }

    @Override
    public void save(ETLLog log) {
        this.save(Collections.singletonList(log));
    }

    @Override
    public void save(Iterable<ETLLog> logs) {
        try (Session session = this.factory.openSession();){
            Transaction tx = session.beginTransaction();
            for (ETLLog log : logs) {
                session.saveOrUpdate((Object)log);
            }
            tx.commit();
        }
    }

    @Override
    public ETLLog get(long logId) {
        ETLLog result = null;
        StringBuilder queryString = new StringBuilder();
        queryString.append("select l from ");
        queryString.append(ETLLog.class.getName());
        queryString.append(" as l where l.logId = :logId");
        try (Session session = this.factory.openSession();){
            Query query = session.createQuery(queryString.toString(), ETLLog.class);
            query.setParameter("logId", (Object)logId);
            List set = query.list();
            if (!set.isEmpty()) {
                result = (ETLLog)set.get(0);
            }
        }
        return result;
    }

    @Override
    public List<ETLLog> get(String loader, String rowId, String archetype) {
        List result;
        StringBuilder queryString = new StringBuilder();
        queryString.append("select l from ");
        queryString.append(ETLLog.class.getName());
        queryString.append(" as l where l.rowId = :rowId");
        if (loader != null) {
            queryString.append(" and loader = :loader");
        }
        if (archetype != null) {
            if (archetype.contains("*")) {
                archetype = archetype.replace("*", "%");
                queryString.append(" and archetype like :archetype");
            } else {
                queryString.append(" and archetype = :archetype");
            }
        }
        try (Session session = this.factory.openSession();){
            Query query = session.createQuery(queryString.toString(), ETLLog.class);
            query.setParameter("rowId", (Object)rowId);
            if (loader != null) {
                query.setParameter("loader", (Object)loader);
            }
            if (archetype != null) {
                query.setParameter("archetype", (Object)archetype);
            }
            result = query.list();
        }
        return result;
    }

    @Override
    public boolean processed(String loader, String rowId) {
        boolean processed;
        StringBuilder queryString = new StringBuilder();
        queryString.append("select errors from ");
        queryString.append(ETLLog.class.getName());
        queryString.append(" as l where l.rowId = :rowId and ");
        queryString.append("l.loader = :loader");
        try (Session session = this.factory.openSession();){
            Query query = session.createQuery(queryString.toString(), String.class);
            query.setParameter("rowId", (Object)rowId);
            query.setParameter("loader", (Object)loader);
            int rows = 0;
            boolean errors = false;
            for (Object value : query.list()) {
                ++rows;
                if (value == null) continue;
                errors = true;
                break;
            }
            processed = rows != 0 && !errors;
        }
        return processed;
    }

    @Override
    public void remove(String loader, String rowId) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("delete from ");
        queryString.append(ETLLog.class.getName());
        queryString.append(" where loader = :loader and rowId = :rowId");
        try (Session session = this.factory.openSession();){
            Transaction transaction = session.beginTransaction();
            Query query = session.createQuery(queryString.toString());
            query.setParameter("loader", (Object)loader);
            query.setParameter("rowId", (Object)rowId);
            query.executeUpdate();
            transaction.commit();
        }
    }
}

