/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.SoftRefIMObjectCache;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.etl.load.ETLLog;
import org.openvpms.etl.load.ETLLogDAO;
import org.openvpms.etl.load.ErrorListener;
import org.openvpms.etl.load.ExceptionHelper;
import org.openvpms.etl.load.LoaderException;
import org.openvpms.etl.load.Mappings;
import org.openvpms.etl.load.ObjectHandler;
import org.openvpms.etl.load.SymbolicReference;
import org.openvpms.etl.load.SymbolicReferenceParser;

public class DefaultObjectHandler
implements ObjectHandler {
    private final String loaderName;
    private final ETLLogDAO dao;
    private final IArchetypeService service;
    private final Map<String, Reference> references = new HashMap<String, Reference>();
    private final Map<String, List<ETLLog>> logs = new HashMap<String, List<ETLLog>>();
    private final List<ETLLog> errorLogs = new ArrayList<ETLLog>();
    private final Map<Reference, IMObject> incomplete = new HashMap<Reference, IMObject>();
    private final Set<String> rowIds = new HashSet<String>();
    private final Map<Reference, IMObject> batch = new LinkedHashMap<Reference, IMObject>();
    private final List<List<IMObject>> batchGroups = new ArrayList<List<IMObject>>();
    private final IMObjectCache cache;
    private final ExceptionHelper messages;
    private ErrorListener listener;
    private long batchSize;

    public DefaultObjectHandler(String loaderName, Mappings mappings, ETLLogDAO dao, IArchetypeService service) {
        this.loaderName = loaderName;
        this.dao = dao;
        this.batchSize = mappings.getBatchSize();
        if (this.batchSize <= 0L) {
            this.batchSize = 1L;
        }
        this.service = service;
        this.cache = new SoftRefIMObjectCache((ArchetypeService)service);
        this.messages = new ExceptionHelper(service);
    }

    @Override
    public void begin() {
        this.cleanup();
    }

    @Override
    public void commit() {
        for (String rowId : this.rowIds) {
            this.dao.remove(this.loaderName, rowId);
        }
        this.rowIds.clear();
        if (!this.incomplete.isEmpty()) {
            this.batch.putAll(this.incomplete);
            this.batchGroups.add(new ArrayList<IMObject>(this.incomplete.values()));
            this.incomplete.clear();
        }
        if ((long)this.batch.size() > this.batchSize) {
            this.save();
        }
    }

    @Override
    public void rollback() {
        for (IMObject object : this.incomplete.values()) {
            for (ETLLog log : this.logs.remove(object.getLinkId())) {
                String reference = SymbolicReference.create(log.getArchetype(), log.getRowId());
                this.references.remove(reference);
            }
        }
        this.incomplete.clear();
    }

    @Override
    public void end() {
        this.commit();
        this.save();
    }

    @Override
    public void close() {
        this.cleanup();
    }

    @Override
    public void add(String rowId, IMObject object, int index) {
        String archetype = object.getArchetype();
        String reference = SymbolicReference.create(archetype, rowId);
        this.references.put(reference, object.getObjectReference());
        List logList = this.logs.computeIfAbsent(object.getLinkId(), k -> new ArrayList());
        logList.add(this.createLog(rowId, object, index));
        this.incomplete.put(object.getObjectReference(), object);
        this.rowIds.add(rowId);
    }

    @Override
    public void error(String rowId, Throwable exception) {
        ETLLog log = new ETLLog(this.loaderName, rowId, null);
        String message = this.messages.getMessage(exception);
        log.setErrors(message);
        this.errorLogs.add(log);
        this.notifyListener(rowId, message, exception);
    }

    @Override
    public IMObject getObject(String reference) {
        IMObject result;
        Reference objectRef = this.references.get(reference);
        if (objectRef != null) {
            result = this.getObject(objectRef, reference);
        } else {
            SymbolicReference ref = SymbolicReferenceParser.parse(reference);
            if (ref == null) {
                throw new LoaderException(LoaderException.ErrorCode.InvalidReference, reference);
            }
            if (ref.getRowId() != null) {
                objectRef = this.getMappedReference(ref);
                result = this.getObject(objectRef, reference);
            } else {
                result = this.getObject(ref);
            }
            this.references.put(ref.toString(), result.getObjectReference());
        }
        return result;
    }

    @Override
    public Reference getReference(String reference) {
        Reference result = this.references.get(reference);
        if (result == null) {
            SymbolicReference ref = SymbolicReferenceParser.parse(reference);
            if (ref == null) {
                throw new LoaderException(LoaderException.ErrorCode.InvalidReference, reference);
            }
            result = ref.getRowId() != null ? this.getMappedReference(ref) : this.getObject(ref).getObjectReference();
            this.references.put(ref.toString(), result);
        }
        return result;
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.listener = listener;
    }

    protected boolean save(Collection<IMObject> objects, Map<String, List<ETLLog>> logs, boolean saveError) {
        boolean result = false;
        try {
            this.service.save(objects);
            for (IMObject object : objects) {
                List<ETLLog> objectLogs = logs.get(object.getLinkId());
                if (objectLogs == null) {
                    throw new IllegalArgumentException("No logs corresponding to object: " + object.getLinkId());
                }
                for (ETLLog log : objectLogs) {
                    log.setReference(object.getObjectReference());
                }
                this.dao.save(objectLogs);
            }
            result = true;
        }
        catch (OpenVPMSException exception) {
            this.handleError(logs, saveError, exception);
        }
        return result;
    }

    protected void saveErrorLogs(Collection<ETLLog> logs) {
        if (!logs.isEmpty()) {
            for (ETLLog errorLog : logs) {
                this.dao.remove(errorLog.getLoader(), errorLog.getRowId());
            }
            this.dao.save(logs);
        }
    }

    private void handleError(Map<String, List<ETLLog>> logs, boolean saveError, OpenVPMSException exception) {
        String message = this.messages.getMessage(exception);
        String rowId = null;
        boolean singleRowId = true;
        if (saveError) {
            for (Collection collection : logs.values()) {
                for (ETLLog log : collection) {
                    if (rowId == null) {
                        rowId = log.getRowId();
                    } else if (!rowId.equals(log.getRowId())) {
                        singleRowId = false;
                    }
                    log.setErrors(message);
                    log.setReference(null);
                }
                this.dao.save(collection);
            }
        }
        if (rowId != null && singleRowId) {
            this.notifyListener(rowId, message, exception);
        } else {
            this.notifyListener(message, exception);
        }
    }

    private void save() {
        if (!this.batch.isEmpty()) {
            if (!this.save(this.batch.values(), this.logs, false)) {
                for (List<IMObject> group : this.batchGroups) {
                    HashMap<String, List<ETLLog>> logMap = new HashMap<String, List<ETLLog>>();
                    for (IMObject object : group) {
                        List<ETLLog> list = this.logs.get(object.getLinkId());
                        if (list == null) {
                            throw new IllegalArgumentException("No logs corresponding to object: " + object.getLinkId());
                        }
                        logMap.put(object.getLinkId(), list);
                    }
                    this.save(group, logMap, true);
                }
            }
            this.saveErrorLogs(this.errorLogs);
            this.batch.clear();
            this.batchGroups.clear();
            this.logs.clear();
            this.errorLogs.clear();
        }
    }

    private Reference getMappedReference(SymbolicReference ref) {
        List<ETLLog> matchingLogs = this.dao.get(null, ref.getRowId(), ref.getArchetype());
        if (matchingLogs.size() != 1) {
            ArrayList<ETLLog> filtered = new ArrayList<ETLLog>();
            for (ETLLog log : matchingLogs) {
                if (!this.loaderName.equals(log.getLoader())) continue;
                filtered.add(log);
            }
            if (!filtered.isEmpty()) {
                matchingLogs = filtered;
            }
        }
        if (matchingLogs.isEmpty()) {
            throw new LoaderException(LoaderException.ErrorCode.IMObjectNotFound, ref.toString());
        }
        if (matchingLogs.size() > 1) {
            throw new LoaderException(LoaderException.ErrorCode.RefResolvesMultipleObjects, ref.toString());
        }
        ETLLog log = matchingLogs.get(0);
        ArchetypeDescriptor archetype = this.service.getArchetypeDescriptor(log.getArchetype());
        if (archetype == null) {
            throw new LoaderException(LoaderException.ErrorCode.ArchetypeNotFound, log.getArchetype());
        }
        IMObjectReference reference = log.getReference();
        if (reference == null) {
            throw new LoaderException(LoaderException.ErrorCode.ReferencedObjectNotMapped, SymbolicReference.create(log.getArchetype(), log.getRowId()), log.getErrors());
        }
        return reference;
    }

    private IMObject getObject(Reference objectRef, String reference) {
        IMObject result = this.incomplete.get(objectRef);
        if (result == null && (result = this.batch.get(objectRef)) == null && (result = this.cache.get(objectRef)) == null) {
            throw new LoaderException(LoaderException.ErrorCode.IMObjectNotFound, reference);
        }
        return result;
    }

    private IMObject getObject(SymbolicReference ref) {
        IMObject result;
        ArchetypeQuery query = new ArchetypeQuery(ref.getArchetype(), true, true);
        query.add((IConstraint)new NodeConstraint(ref.getName(), (Object)ref.getValue()));
        query.setMaxResults(2);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        if (iterator.hasNext()) {
            result = (IMObject)iterator.next();
            if (iterator.hasNext()) {
                throw new LoaderException(LoaderException.ErrorCode.RefResolvesMultipleObjects, ref.toString());
            }
        } else {
            throw new LoaderException(LoaderException.ErrorCode.IMObjectNotFound, ref.toString());
        }
        return result;
    }

    private ETLLog createLog(String rowId, IMObject object, int index) {
        ETLLog log = new ETLLog(this.loaderName, rowId, object.getArchetype(), index);
        log.setReference(object.getObjectReference());
        return log;
    }

    private void notifyListener(String message, Throwable exception) {
        if (this.listener != null) {
            this.listener.error(message, exception);
        }
    }

    private void notifyListener(String rowId, String message, Throwable exception) {
        if (this.listener != null) {
            this.listener.error(rowId, message, exception);
        }
    }

    private void cleanup() {
        this.references.clear();
        this.incomplete.clear();
        this.rowIds.clear();
        this.batch.clear();
        this.batchGroups.clear();
    }
}

