/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.enumerator;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.codehaus.janino.util.enumerator.EnumeratorFormatException;

public abstract class EnumeratorSet {
    private final int values;
    private static final Map mappings = new HashMap();

    protected EnumeratorSet(int n) {
        this.values = n;
    }

    protected EnumeratorSet(String string) throws EnumeratorFormatException {
        this(string, ",");
    }

    protected EnumeratorSet(String string, String string2) throws EnumeratorFormatException {
        Map map = this.getMapping();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            Integer n2 = (Integer)map.get(string3);
            if (n2 == null) {
                throw new EnumeratorFormatException(string3);
            }
            n |= n2.intValue();
        }
        this.values = n;
    }

    protected int add(EnumeratorSet enumeratorSet) {
        return this.values | enumeratorSet.values;
    }

    public boolean contains(EnumeratorSet enumeratorSet) {
        if (this.getClass() != enumeratorSet.getClass()) {
            throw new RuntimeException("EnumeratorSet class mismatch");
        }
        return (this.values & enumeratorSet.values) != 0;
    }

    public boolean containsAllOf(EnumeratorSet enumeratorSet) {
        if (this.getClass() != enumeratorSet.getClass()) {
            throw new RuntimeException("EnumeratorSet class mismatch");
        }
        return (this.values & enumeratorSet.values) == enumeratorSet.values;
    }

    public boolean containsAnyOf(EnumeratorSet enumeratorSet) {
        if (this.getClass() != enumeratorSet.getClass()) {
            throw new RuntimeException("EnumeratorSet class mismatch");
        }
        return (this.values & enumeratorSet.values) != 0;
    }

    public boolean equals(Object object) {
        return object.getClass() == this.getClass() && this.values == ((EnumeratorSet)object).values;
    }

    private Map getMapping() {
        Class<?> clazz = this.getClass();
        Map map = (Map)mappings.get(clazz);
        if (map != null) {
            return map;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            if (field.getType() == clazz && (field.getModifiers() & 0x18) == 24) {
                try {
                    EnumeratorSet enumeratorSet = (EnumeratorSet)field.get(null);
                    hashMap.put(field.getName(), new Integer(enumeratorSet.values));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("SNO: Field \"" + field + "\" is inaccessible");
                }
            }
            ++n;
        }
        mappings.put(this.getClass(), hashMap);
        return hashMap;
    }

    public int hashCode() {
        return this.values;
    }

    protected int remove(EnumeratorSet enumeratorSet) {
        return this.values & ~enumeratorSet.values;
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String string) {
        int n = this.values;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        Iterator iterator = this.getMapping().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int n2 = (Integer)entry.getValue();
            if (n2 == 0) {
                string2 = (String)entry.getKey();
                continue;
            }
            if ((n & n2) != n2) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append((String)entry.getKey());
            n &= ~n2;
        }
        if (this.values == 0) {
            return string2 == null ? "0" : string2;
        }
        if (n != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }
}

