/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TaskRules {
    private final ArchetypeService service;

    public TaskRules(ArchetypeService service) {
        this.service = service;
    }

    public Entity getWorkList(Act task) {
        IMObjectBean bean = this.service.getBean((IMObject)task);
        return (Entity)bean.getTarget("worklist", Entity.class);
    }

    public Entity getWorkListView(Party location, Entity worklist) {
        IMObjectBean bean = this.service.getBean((IMObject)location);
        for (Entity view : bean.getTargets("workListViews", Entity.class, Policies.orderBySequence())) {
            IMObjectBean viewBean = this.service.getBean((IMObject)view);
            if (!viewBean.hasTarget("workLists", (IMObject)worklist)) continue;
            return view;
        }
        return null;
    }

    public boolean hasTaskType(Entity worklist, Entity taskType) {
        IMObjectBean bean = this.service.getBean((IMObject)worklist);
        return bean.hasTarget("taskTypes", (IMObject)taskType);
    }
}

