/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.FreeSlotIterator;
import org.openvpms.archetype.rules.workflow.Slot;

class FreeSlotIterators
implements Iterator<Slot> {
    private final List<PeekingIterator<Slot>> iterators = new ArrayList<PeekingIterator<Slot>>();
    private Iterator<Slot> next;

    public FreeSlotIterators(List<FreeSlotIterator> iterators, Predicate<Slot> predicate) {
        for (FreeSlotIterator iterator : iterators) {
            FilterIterator filtered = new FilterIterator((Iterator)iterator, predicate);
            this.iterators.add((PeekingIterator<Slot>)new PeekingIterator((Iterator)filtered));
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.getNext();
        }
        return this.next != null;
    }

    @Override
    public Slot next() {
        if (this.next == null) {
            this.getNext();
        }
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Slot slot = this.next.next();
        this.next = null;
        return slot;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void getNext() {
        this.next = null;
        ListIterator<PeekingIterator<Slot>> listIterator = this.iterators.listIterator();
        Date minDate = null;
        while (listIterator.hasNext()) {
            PeekingIterator<Slot> iterator = listIterator.next();
            if (!iterator.hasNext()) {
                listIterator.remove();
                continue;
            }
            Slot slot = (Slot)iterator.peek();
            if (minDate != null && DateRules.compareTo(minDate, slot.getStartTime()) <= 0) continue;
            minDate = slot.getStartTime();
            this.next = iterator;
        }
    }
}

