/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.user;

import org.openvpms.archetype.rules.settings.Settings;
import org.openvpms.archetype.rules.user.AbstractPasswordPolicy;

public class PasswordPolicySettings
extends AbstractPasswordPolicy {
    private final Settings settings;
    private static final int MIN_LENGTH = 6;
    private static final int DEFAULT_LENGTH = 8;

    public PasswordPolicySettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public int getMinLength() {
        int minLength = this.settings.getInt("entity.globalSettingsPassword", "minLength", 8);
        if (minLength < 6) {
            minLength = 6;
        }
        return minLength;
    }

    @Override
    public boolean lowercaseRequired() {
        return this.settings.getBoolean("entity.globalSettingsPassword", "lowercase", true);
    }

    @Override
    public boolean uppercaseRequired() {
        return this.settings.getBoolean("entity.globalSettingsPassword", "uppercase", true);
    }

    @Override
    public boolean numberRequired() {
        return this.settings.getBoolean("entity.globalSettingsPassword", "number", true);
    }

    @Override
    public boolean specialRequired() {
        return this.settings.getBoolean("entity.globalSettingsPassword", "special", true);
    }
}

