/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.Set;
import org.openvpms.archetype.rules.party.PartyMerger;
import org.openvpms.archetype.rules.patient.PatientRelationshipRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;

public class PatientMerger
extends PartyMerger {
    public static final String DESEXED = "desexed";
    public static final String DECEASED = "deceased";

    public PatientMerger(IArchetypeService service) {
        super("party.patientpet", service);
    }

    @Override
    protected void merge(Party from, Party to, Set<IMObject> merged) {
        IArchetypeService service = this.getArchetypeService();
        IMObjectBean fromBean = service.getBean((IMObject)from);
        boolean desexed = fromBean.getBoolean(DESEXED);
        boolean deceased = fromBean.getBoolean(DECEASED);
        super.merge(from, to, merged);
        if (desexed || deceased) {
            IMObjectBean toBean = service.getBean((IMObject)to);
            if (desexed) {
                toBean.setValue(DESEXED, (Object)true);
            }
            if (deceased) {
                toBean.setValue(DECEASED, (Object)true);
            }
        }
    }

    @Override
    protected void copyEntityRelationships(Party from, Party to) {
        super.copyEntityRelationships(from, to);
        PatientRelationshipRules.checkRelationships(to);
    }
}

