/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.till;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.collections4.comparators.NullComparator;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.component.business.dao.im.Page;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.ObjectSet;

public class TillBalanceQuery {
    public static final String TILL_BALANCE = "tillBalance";
    public static final String ACT = "act";
    public static final String ACT_ITEM = "item";
    public static final String AMOUNT = "amount";
    private final FinancialAct tillBalance;
    private final IArchetypeService service;
    private final ActCalculator calculator;

    public TillBalanceQuery(FinancialAct tillBalance, IArchetypeService service) {
        this.tillBalance = tillBalance;
        this.service = service;
        this.calculator = new ActCalculator((ArchetypeService)service);
    }

    public IPage<ObjectSet> query() {
        ArrayList<ObjectSet> result = new ArrayList<ObjectSet>();
        IMObjectBean bean = this.service.getBean((IMObject)this.tillBalance);
        for (Act tillBalanceItem : bean.getTargets("items", Act.class)) {
            IMObjectBean tillBalanceItemBean = this.service.getBean((IMObject)tillBalanceItem);
            if (tillBalanceItemBean.isA(new String[]{"act.tillBalanceAdjustment"})) {
                ObjectSet set = new ObjectSet();
                set.set(TILL_BALANCE, (Object)this.tillBalance);
                set.set(ACT, (Object)tillBalanceItem);
                set.set(ACT_ITEM, null);
                set.set(AMOUNT, (Object)this.getAmount(tillBalanceItem).negate());
                result.add(set);
                continue;
            }
            for (Act item : tillBalanceItemBean.getTargets("items", Act.class)) {
                ObjectSet set = new ObjectSet();
                set.set(TILL_BALANCE, (Object)this.tillBalance);
                set.set(ACT, (Object)tillBalanceItem);
                set.set(ACT_ITEM, (Object)item);
                set.set(AMOUNT, (Object)this.getAmount(item).negate());
                result.add(set);
            }
        }
        result.sort((o1, o2) -> {
            Act a1 = (Act)o1.get(ACT);
            Act a2 = (Act)o2.get(ACT);
            NullComparator comparator = new NullComparator();
            return comparator.compare(a1.getActivityStartTime(), a2.getActivityStartTime());
        });
        return new Page(result, 0, result.size(), result.size());
    }

    private BigDecimal getAmount(Act act) {
        return this.calculator.getAmount(act, AMOUNT);
    }
}

