/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.reminder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class AccountReminderRules {
    private final CustomerAccountRules accountRules;
    private final InsuranceRules insuranceRules;
    private final IArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private static final String ERROR = "error";
    private static final String CHARGE = "charge";
    private static final String STATUS = "status";
    private static final String SEND_REMINDER = "sendReminder";
    private static final String REMINDERS = "reminders";

    public AccountReminderRules(CustomerAccountRules accountRules, InsuranceRules insuranceRules, IArchetypeService service, PlatformTransactionManager transactionManager) {
        if (service instanceof IArchetypeRuleService) {
            throw new IllegalArgumentException("Argument 'service' should not implement " + IArchetypeRuleService.class.getSimpleName());
        }
        this.accountRules = accountRules;
        this.insuranceRules = insuranceRules;
        this.service = service;
        this.transactionManager = transactionManager;
    }

    public boolean needsReminder(FinancialAct charge, BigDecimal minBalance) {
        boolean result = false;
        if ("POSTED".equals(charge.getStatus()) && this.hasBalanceGreaterThanOrEqualToMinBalance(charge, minBalance)) {
            IMObjectBean bean = this.service.getBean((IMObject)charge);
            result = this.sendReminderFlagSet(bean) && this.isPaymentOverdue(bean) && this.notClaimed(charge);
        }
        return result;
    }

    public boolean resolveError(Act reminder) {
        boolean result = false;
        this.checkArchetype(reminder);
        String status = reminder.getStatus();
        if ("ERROR".equals(status)) {
            IMObjectBean bean = this.service.getBean((IMObject)reminder);
            bean.setValue(STATUS, (Object)"PENDING");
            bean.setValue(ERROR, null);
            this.service.save((IMObject)reminder);
            result = true;
        }
        return result;
    }

    public boolean enableReminders(FinancialAct charge) {
        IMObjectBean bean;
        boolean result = false;
        if (this.canHaveReminders(charge) && this.isUnpaid(charge) && !this.sendReminderFlagSet(bean = this.service.getBean((IMObject)charge))) {
            bean.setValue(SEND_REMINDER, (Object)true);
            result = true;
            this.service.save((IMObject)charge);
        }
        return result;
    }

    public boolean disableReminders(FinancialAct charge) {
        boolean result = false;
        IMObjectBean bean = this.service.getBean((IMObject)charge);
        if (this.canHaveReminders(charge) && this.sendReminderFlagSet(bean)) {
            TransactionTemplate template = new TransactionTemplate(this.transactionManager);
            template.executeWithoutResult(transactionStatus -> {
                bean.setValue(SEND_REMINDER, (Object)false);
                ArrayList<Act> toRemove = new ArrayList<Act>();
                for (Act reminder : bean.getTargets(REMINDERS, Act.class)) {
                    if (!"PENDING".equals(reminder.getStatus()) && !"ERROR".equals(reminder.getStatus())) continue;
                    bean.removeTargets(REMINDERS, (IMObject)reminder, CHARGE);
                    toRemove.add(reminder);
                }
                this.service.save(bean.getObject());
                for (Act reminder : toRemove) {
                    this.service.remove((IMObject)reminder);
                }
            });
            result = true;
        }
        return result;
    }

    public boolean canEnableReminders(FinancialAct act) {
        return this.canHaveReminders(act) && this.isUnpaid(act) && !this.sendReminderFlagSet(act);
    }

    public boolean canDisableReminders(FinancialAct act) {
        return this.canHaveReminders(act) && this.sendReminderFlagSet(act);
    }

    private boolean sendReminderFlagSet(FinancialAct charge) {
        return this.sendReminderFlagSet(this.service.getBean((IMObject)charge));
    }

    private boolean sendReminderFlagSet(IMObjectBean charge) {
        return charge.getBoolean(SEND_REMINDER);
    }

    private boolean isPaymentOverdue(IMObjectBean charge) {
        boolean result = false;
        Date completed = charge.getDate("endTime");
        Party customer = (Party)charge.getTarget("customer", Party.class);
        if (completed != null && customer != null) {
            Date now = new Date();
            Date overdueDate = this.accountRules.getOverdueDate(customer, now);
            result = completed.before(overdueDate);
        }
        return result;
    }

    private boolean notClaimed(FinancialAct charge) {
        boolean result = charge.isA("act.customerAccountChargesInvoice") ? !this.insuranceRules.isClaimed(charge) : true;
        return result;
    }

    private boolean hasBalanceGreaterThanOrEqualToMinBalance(FinancialAct charge, BigDecimal minBalance) {
        BigDecimal remaining;
        boolean result = false;
        BigDecimal total = charge.getTotal();
        if (MathRules.isPositive(total) && !MathRules.isZero(remaining = total.subtract(charge.getAllocatedAmount())) && remaining.compareTo(minBalance) >= 0) {
            result = true;
        }
        return result;
    }

    private boolean canHaveReminders(FinancialAct act) {
        return act.isA(new String[]{"act.customerAccountChargesInvoice", "act.customerAccountChargesCounter"});
    }

    private boolean isUnpaid(FinancialAct act) {
        return act.getTotal().compareTo(act.getAllocatedAmount()) > 0;
    }

    private void checkArchetype(Act reminder) {
        if (!reminder.isA("act.customerChargeReminderSMS")) {
            throw new IllegalArgumentException("Invalid reminder archetype: " + reminder.getArchetype());
        }
    }
}

