/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.invoice;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.rules.finance.invoice.DemographicUpdateHelper;
import org.openvpms.archetype.rules.finance.invoice.InvoiceItemSaveRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.ObjectRelationship;
import org.openvpms.component.model.bean.RelatedIMObjects;
import org.openvpms.component.model.object.IMObject;

public class InvoiceRules {
    private final IArchetypeService service;
    private static final String[] REMINDER_STATUSES = new String[]{"COMPLETED"};
    private static final String[] ALERT_STATUSES = new String[]{"COMPLETED"};
    private static final String[] DOCUMENT_STATUSES = new String[]{"COMPLETED", "POSTED"};
    private static final String[] TASK_STATUSES = new String[]{"BILLED", "COMPLETED"};

    public InvoiceRules(IArchetypeService service) {
        this.service = service;
    }

    public void saveInvoiceItem(FinancialAct act) {
        InvoiceItemSaveRules rules = new InvoiceItemSaveRules((Act)act, this.service);
        rules.save();
    }

    public void saveInvoice(FinancialAct invoice) {
        if (!invoice.isA("act.customerAccountChargesInvoice")) {
            throw new IllegalArgumentException("Invalid argument 'invoice'");
        }
        if ("POSTED".equals(invoice.getStatus())) {
            IMObjectBean bean = this.service.getBean((IMObject)invoice);
            List acts = bean.getTargets("items", Act.class);
            for (Act act : acts) {
                DemographicUpdateHelper helper = new DemographicUpdateHelper(act, this.service);
                helper.processDemographicUpdates((Act)invoice);
            }
        }
    }

    public void removeInvoice(FinancialAct invoice) {
        if (!invoice.isA("act.customerAccountChargesInvoice")) {
            throw new IllegalArgumentException("Invalid argument 'invoice'");
        }
        IMObjectBean bean = this.service.getBean((IMObject)invoice);
        List acts = bean.getTargets("items", Act.class);
        for (Act act : acts) {
            this.removeInvoiceItem((FinancialAct)act);
        }
    }

    public void removeInvoiceItem(FinancialAct act) {
        if (!act.isA("act.customerAccountInvoiceItem")) {
            throw new IllegalArgumentException("Invalid argument 'act'");
        }
        ArrayList<Act> toRemove = new ArrayList<Act>();
        this.removeInvestigations(act, toRemove);
        this.removeRelatedActs(act, "reminders", REMINDER_STATUSES, toRemove);
        this.removeRelatedActs(act, "alerts", ALERT_STATUSES, toRemove);
        this.removeRelatedActs(act, "documents", DOCUMENT_STATUSES, toRemove);
        this.removeRelatedActs(act, "tasks", TASK_STATUSES, toRemove);
        if (!toRemove.isEmpty()) {
            this.service.save((IMObject)act);
            this.service.save(toRemove);
            for (Act remove : toRemove) {
                this.service.remove((IMObject)remove);
            }
        }
    }

    private void removeInvestigations(FinancialAct item, List<Act> toRemove) {
        IMObjectBean bean = this.service.getBean((IMObject)item);
        RelatedIMObjects investigations = bean.getRelated("investigations", DocumentAct.class);
        for (ObjectRelationship investigation : investigations.getObjectRelationships()) {
            DocumentAct act = (DocumentAct)investigation.getObject();
            String status = act.getStatus();
            if (!"IN_PROGRESS".equals(status) || act.getDocument() != null) continue;
            toRemove.add((Act)act);
            ActRelationship relationship = (ActRelationship)investigation.getRelationship();
            act.removeActRelationship(relationship);
            item.removeActRelationship(relationship);
        }
    }

    private void removeRelatedActs(FinancialAct item, String node, String[] statuses, List<Act> toRemove) {
        IMObjectBean bean = this.service.getBean((IMObject)item);
        RelatedIMObjects relatedItems = bean.getRelated(node, Act.class, ActRelationship.class);
        for (ObjectRelationship related : relatedItems.getObjectRelationships()) {
            Act act = (Act)related.getObject();
            String status = act.getStatus();
            ActRelationship relationship = (ActRelationship)related.getRelationship();
            boolean retain = false;
            for (String s : statuses) {
                if (!s.equals(status)) continue;
                retain = true;
                break;
            }
            if (retain) continue;
            toRemove.add(act);
            act.removeActRelationship(relationship);
            item.removeActRelationship(relationship);
        }
    }
}

