/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.util.Arrays;
import java.util.List;
import org.openvpms.archetype.rules.act.ActCopyHandler;
import org.openvpms.archetype.rules.finance.account.TransactionRules;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

class CustomerActReversalHandler
extends ActCopyHandler {
    private final boolean post;
    static final String[][] TYPE_MAP = new String[][]{{"act.customerAccountChargesInvoice", "act.customerAccountChargesCredit"}, {"act.customerAccountInvoiceItem", "act.customerAccountCreditItem"}, {"actRelationship.customerAccountInvoiceItem", "actRelationship.customerAccountCreditItem"}, {"act.customerAccountChargesCounter", "act.customerAccountChargesCredit"}, {"act.customerAccountCounterItem", "act.customerAccountCreditItem"}, {"actRelationship.customerAccountCounterItem", "actRelationship.customerAccountCreditItem"}, {"act.customerAccountPayment", "act.customerAccountRefund"}, {"actRelationship.customerAccountPaymentItem", "actRelationship.customerAccountRefundItem"}, {"act.customerAccountPaymentCash", "act.customerAccountRefundCash"}, {"act.customerAccountPaymentCheque", "act.customerAccountRefundCheque"}, {"act.customerAccountPaymentCredit", "act.customerAccountRefundCredit"}, {"act.customerAccountPaymentDiscount", "act.customerAccountRefundDiscount"}, {"act.customerAccountPaymentEFT", "act.customerAccountRefundEFT"}, {"act.customerAccountPaymentOther", "act.customerAccountRefundOther"}, {"act.customerAccountPaymentPP", "act.customerAccountRefundPP"}, {"act.customerAccountDebitAdjust", "act.customerAccountCreditAdjust"}, {"act.customerAccountDebitAdjust", "act.customerAccountBadDebt"}, {"act.customerAccountInitialBalance", "act.customerAccountCreditAdjust"}};
    private final List<String> UNCOPYABLE = Arrays.asList("credit", "allocatedAmount", "accountBalance", "allocation", "reversals", "reverses", "estimates", "hide", "tillBalance", "audit", "transaction", "transactions", "reversal");

    CustomerActReversalHandler(Act act, boolean post) {
        super(TYPE_MAP);
        this.setReverse(act.isA(new String[]{"act.customerAccountChargesCredit", "act.customerAccountRefund", "act.customerAccountCreditAdjust", "act.customerAccountBadDebt"}));
        this.post = post;
    }

    @Override
    public IMObject getObject(IMObject object, ArchetypeService service) {
        IMObject result = super.getObject(object, service);
        if (object.isA("act.customerAccountRefundCash") && result.isA("act.customerAccountPaymentCash")) {
            IMObjectBean refund = service.getBean(object);
            IMObjectBean payment = service.getBean(result);
            payment.setValue("tendered", (Object)refund.getBigDecimal("roundedAmount"));
        } else if (object.isA("act.customerAccountPaymentEFT")) {
            FinancialAct latest = this.getMostRecentTransaction((FinancialAct)object, service);
            if (latest != null && "APPROVED".equals(latest.getStatus())) {
                if (this.post) {
                    throw new IllegalStateException("Cannot reverse " + object.getArchetype());
                }
                this.addReversal(object, result, "act.customerAccountRefundEFT", service);
            }
        } else if (object.isA("act.customerAccountRefundEFT")) {
            FinancialAct latest = this.getMostRecentTransaction((FinancialAct)object, service);
            if (latest != null && "APPROVED".equals(latest.getStatus())) {
                throw new IllegalStateException("Cannot reverse " + object.getArchetype());
            }
        } else if (object.isA("act.customerAccountPaymentPP")) {
            if (this.post) {
                throw new IllegalStateException("Cannot reverse " + object.getArchetype());
            }
            this.addReversal(object, result, "act.customerAccountRefundPP", service);
        } else if (object.isA("act.customerAccountRefundPP")) {
            throw new IllegalStateException("Cannot reverse " + object.getArchetype());
        }
        return result;
    }

    private FinancialAct getMostRecentTransaction(FinancialAct item, ArchetypeService service) {
        TransactionRules rules = new TransactionRules(service);
        return rules.getMostRecentTransaction(item);
    }

    private void addReversal(IMObject object, IMObject reversal, String archetype, ArchetypeService service) {
        if (!reversal.isA(archetype)) {
            throw new IllegalStateException("Invalid reversal " + reversal.getArchetype());
        }
        IMObjectBean payment = service.getBean(object);
        payment.addTarget("reversal", reversal, "reverses");
    }

    @Override
    protected boolean isCopyable(ArchetypeDescriptor archetype, NodeDescriptor node, boolean source) {
        String name = node.getName();
        if (this.UNCOPYABLE.contains(name)) {
            return false;
        }
        return super.isCopyable(archetype, node, source);
    }
}

