/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TemplateHelper {
    private final ArchetypeService service;

    public TemplateHelper(ArchetypeService service) {
        this.service = service;
    }

    public Document getDocument(String name) {
        Document result = null;
        DocumentAct act = this.getDocumentAct(name);
        if (act != null) {
            result = (Document)this.get(act.getDocument());
        }
        return result;
    }

    public DocumentAct getDocumentAct(String name) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DocumentAct.class);
        Root root = query.from(DocumentAct.class, new String[]{"act.documentTemplate"});
        Join template = root.join("template").join("entity");
        query.where(new Predicate[]{builder.equal((Expression)root.get("name"), (Object)name), builder.equal((Expression)template.get("active"), (Object)true)});
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return (DocumentAct)this.service.createQuery(query).getFirstResult();
    }

    public Entity getTemplateForType(String type) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{"entity.documentTemplate"});
        Join typeJoin = root.join("type");
        typeJoin.on((Expression)builder.equal((Expression)typeJoin.get("code"), (Object)type));
        query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return (Entity)this.service.createQuery(query).getFirstResult();
    }

    public Entity getTemplateForType(String type, Party organisation) {
        Entity result = null;
        IMObjectBean bean = this.service.getBean((IMObject)organisation);
        List templates = bean.getSourceRefs("templates", Policies.active());
        if (!templates.isEmpty()) {
            List templateIds = templates.stream().map(Reference::getId).collect(Collectors.toList());
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Entity.class);
            Root root = query.from(Entity.class, new String[]{"entity.documentTemplate"});
            Join typeJoin = root.join("type");
            typeJoin.on((Expression)builder.equal((Expression)typeJoin.get("code"), (Object)type));
            query.where(Arrays.asList(root.get("id").in(templateIds), builder.equal((Expression)root.get("active"), (Object)true)));
            query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
            result = (Entity)this.service.createQuery(query).getFirstResult();
        }
        return result;
    }

    public DocumentTemplate getDocumentTemplate(String type) {
        Entity result = this.getTemplateForType(type);
        return result != null ? new DocumentTemplate(result, this.service) : null;
    }

    public DocumentTemplate getDocumentTemplate(String type, Party organisation) {
        Entity result = this.getTemplateForType(type, organisation);
        return result != null ? new DocumentTemplate(result, this.service) : null;
    }

    public Document getDocumentFromTemplate(Entity template) {
        DocumentAct act = this.getDocumentAct(template);
        if (act != null) {
            return (Document)this.get(act.getDocument());
        }
        return null;
    }

    public DocumentAct getDocumentAct(Entity template) {
        DocumentAct result = null;
        Participation participation = this.getDocumentParticipation(template);
        if (participation != null) {
            result = (DocumentAct)this.get(participation.getAct());
        }
        return result;
    }

    public Participation getDocumentParticipation(Entity template) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Participation.class);
        Root root = query.from(Participation.class, new String[]{"participation.document"});
        query.where((Expression)builder.equal((Expression)root.get("entity"), (Object)template.getObjectReference()));
        return (Participation)this.service.createQuery(query).getFirstResult();
    }

    public String getFileName(Entity template) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(String.class);
        Root root = query.from(DocumentAct.class, new String[]{"act.documentTemplate"});
        Join join = root.join("template");
        query.select((Selection)root.get("fileName"));
        query.where((Expression)builder.equal((Expression)join.get("entity"), (Object)template.getObjectReference()));
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return (String)this.service.createQuery(query).getFirstResult();
    }

    private IMObject get(Reference ref) {
        return ref != null ? this.service.get(ref) : null;
    }
}

