/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.party;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.function.Predicate;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.Pointer;
import org.openvpms.archetype.function.patient.PatientFunctions;
import org.openvpms.archetype.rules.contact.AddressFormatter;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.FunctionHelper;

public class PartyFunctions {
    private final IArchetypeService service;
    private final PartyRules partyRules;
    private final PatientRules patientRules;
    private final SupplierRules supplierRules;
    private final AppointmentRules appointmentRules;
    private final PatientFunctions patientFunctions;
    private static final Policy<Participation> CUSTOMER_PARTICIPATION = Policies.any(Participation.class, (Predicate)Predicates.isA((String[])new String[]{"participation.customer"}));

    public PartyFunctions(IArchetypeService service, LookupService lookups, PatientRules patientRules, AddressFormatter addressFormatter) {
        this.service = service;
        this.patientRules = patientRules;
        this.partyRules = new PartyRules(service, lookups, addressFormatter);
        this.supplierRules = new SupplierRules(service);
        this.appointmentRules = new AppointmentRules(service);
        this.patientFunctions = new PatientFunctions(patientRules, this.supplierRules, this.appointmentRules, new MedicalRecordRules(service), service);
    }

    @Deprecated
    public Object getCustomerNode(Object object, String nodeName) {
        Party customer = this.unwrapParty(object);
        return customer != null ? this.partyRules.getCustomerNode(customer, nodeName) : null;
    }

    public String getPartyFullName(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getPartyFullName(pointer.getValue());
    }

    public String getPartyFullName(Object object) {
        Party party = this.unwrapParty(object);
        return party != null ? this.partyRules.getFullName(party) : "";
    }

    public Party getPatientOwner(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getPatientOwner(pointer.getValue());
    }

    public Party getPatientOwner(Object object) {
        Party patient = this.patientFunctions.get(object);
        if (patient != null) {
            if (object instanceof Act) {
                Date date = ((Act)object).getActivityStartTime();
                return this.patientFunctions.owner(patient, date);
            }
            return this.patientFunctions.owner(patient);
        }
        return null;
    }

    public Party getPatientCurrentOwner(Act act) {
        return this.patientRules.getCurrentOwner(act);
    }

    public Party getPatientLocation(Object object) {
        if ((object = FunctionHelper.unwrap((Object)object)) instanceof Party) {
            return this.patientRules.getLocation((Party)object);
        }
        if (object instanceof Act) {
            return this.patientRules.getLocation((Act)object);
        }
        return null;
    }

    public Party getPatientCurrentLocation(Act act) {
        return this.patientRules.getCurrentLocation(act);
    }

    public void setPatientInactive(Party patient) {
        this.patientRules.setInactive(patient);
    }

    public void setPatientDeceased(Party patient) {
        this.patientRules.setDeceased(patient);
    }

    public void setPatientDesexed(Party patient) {
        this.patientRules.setDesexed(patient);
    }

    public String getPreferredContacts(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getPreferredContacts(pointer.getValue());
    }

    public String getPreferredContacts(Object object) {
        Party party = this.unwrapParty(object);
        return party != null ? this.partyRules.getPreferredContacts(party) : "";
    }

    public String getBillingAddress(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getBillingAddress(pointer.getValue());
    }

    public String getBillingAddress(Object object) {
        return this.getBillingAddress(object, false);
    }

    public String getBillingAddress(Object object, boolean singleLine) {
        Party customer = this.unwrapParty(object);
        return customer != null ? this.partyRules.getBillingAddress(customer, singleLine) : "";
    }

    public String getCorrespondenceAddress(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getCorrespondenceAddress(pointer.getValue());
    }

    public String getCorrespondenceAddress(Object object) {
        return this.getCorrespondenceAddress(object, false);
    }

    public String getCorrespondenceAddress(Object object, boolean singleLine) {
        Party party = this.unwrapParty(object);
        return party != null ? this.partyRules.getCorrespondenceAddress(party, singleLine) : "";
    }

    public String getAddress(Party party, String purpose) {
        return this.getAddress(party, purpose, false);
    }

    public String getAddress(Party party, String purpose, boolean singleLine) {
        return this.partyRules.getAddress(party, purpose, singleLine);
    }

    public String getTelephone(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getTelephone(pointer.getValue());
    }

    public String getTelephone(Object object) {
        Party party = this.unwrapParty(object);
        return party != null ? this.partyRules.getTelephone(party) : "";
    }

    public String getHomeTelephone(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getHomeTelephone(pointer.getValue());
    }

    public String getHomeTelephone(Object object) {
        Party party = this.unwrapParty(object);
        return party != null ? this.partyRules.getHomeTelephone(party) : "";
    }

    public String getWorkTelephone(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getWorkTelephone(pointer.getValue());
    }

    public String getWorkTelephone(Object object) {
        Party party = this.unwrapParty(object);
        return party != null ? this.partyRules.getWorkTelephone(party) : "";
    }

    public String getMobileTelephone(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getMobileTelephone(pointer.getValue());
    }

    public String getMobileTelephone(Object object) {
        Party party = this.unwrapParty(object);
        return party != null ? this.partyRules.getMobileTelephone(party) : "";
    }

    public String getFaxNumber(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getFaxNumber(pointer.getValue());
    }

    public String getFaxNumber(Object object) {
        Party party = this.unwrapParty(object);
        return party != null ? this.partyRules.getFaxNumber(party) : "";
    }

    public String getEmailAddress(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getEmailAddress(pointer.getValue());
    }

    public String getEmailAddress(Object object) {
        Party party = this.unwrapParty(object);
        return party != null ? this.partyRules.getEmailAddress(party) : "";
    }

    public String getWebsite(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getWebsite(pointer.getValue());
    }

    public String getWebsite(Object object) {
        Party party = this.unwrapParty(object);
        return party != null ? this.partyRules.getWebsite(party) : "";
    }

    public String getContactPurposes(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        if (pointer == null || !(pointer.getValue() instanceof Contact)) {
            return "";
        }
        Contact contact = (Contact)pointer.getValue();
        return this.partyRules.getContactPurposes(contact);
    }

    public String identities(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.identities(pointer.getValue());
    }

    public String identities(Object object) {
        Party party = (object = FunctionHelper.unwrap((Object)object)) instanceof Party ? (Party)object : this.patientFunctions.get(object);
        return party != null ? this.partyRules.getIdentities(party) : "";
    }

    public BigDecimal getAccountBalance(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getAccountBalance(pointer.getValue());
    }

    public BigDecimal getAccountBalance(Object object) {
        BigDecimal result = BigDecimal.ZERO;
        Party party = this.unwrapParty(object);
        if (party != null) {
            BalanceCalculator calculator = new BalanceCalculator(this.service);
            result = calculator.getBalance(party);
        }
        return result;
    }

    public Party getPatientReferralVet(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getPatientReferralVet(pointer.getValue());
    }

    public Party getPatientReferralVet(Object object) {
        Party vet = null;
        Party patient = this.patientFunctions.get(object = FunctionHelper.unwrap((Object)object));
        if (patient != null) {
            if (object instanceof Act) {
                Act act = (Act)object;
                Date startTime = act.getActivityStartTime();
                if (startTime != null) {
                    vet = this.patientFunctions.referral(patient, false, startTime);
                }
            } else {
                vet = this.patientFunctions.referral(patient, false);
            }
        }
        return vet;
    }

    public Party getPatientReferralVetPractice(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getPatientReferralVetPractice(pointer.getValue());
    }

    public Party getPatientReferralVetPractice(Object object) {
        Party result = null;
        Party patient = this.patientFunctions.get(object = FunctionHelper.unwrap((Object)object));
        if (patient != null) {
            if (object instanceof Act) {
                Act act = (Act)object;
                Date startTime = act.getActivityStartTime();
                if (startTime != null) {
                    return this.patientFunctions.referral(patient, true, startTime);
                }
            } else {
                return this.patientFunctions.referral(patient, true);
            }
        }
        return result;
    }

    public Party getReferralVetPractice(Party vet, Date time) {
        return this.supplierRules.getReferralVetPractice(vet, time);
    }

    public String getPatientAge(ExpressionContext context) {
        return this.getPatientAge(context.getContextNodePointer().getValue());
    }

    public String getPatientAge(Object object) {
        String result = null;
        Party patient = this.patientFunctions.get(object);
        if (patient != null) {
            result = this.patientFunctions.age(patient);
        }
        return result != null ? result : "";
    }

    public String getPatientMicrochip(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getPatientMicrochip(pointer.getValue());
    }

    public String getPatientMicrochip(Object object) {
        String result = null;
        Party patient = this.patientFunctions.get(object);
        if (patient != null) {
            result = this.patientRules.getMicrochipNumber(patient);
        }
        return result != null ? result : "";
    }

    public String getPatientMicrochips(Object object) {
        String result = null;
        Party patient = this.patientFunctions.get(object);
        if (patient != null) {
            result = this.patientRules.getMicrochipNumbers(patient);
        }
        return result != null ? result : "";
    }

    public EntityIdentity getMicrochip(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getMicrochip(pointer.getValue());
    }

    public EntityIdentity getMicrochip(Object object) {
        Party patient = this.patientFunctions.get(object);
        return patient != null ? this.patientRules.getMicrochip(patient) : null;
    }

    public String getPatientPetTag(Object object) {
        String result = null;
        Party patient = this.patientFunctions.get(object);
        if (patient != null) {
            result = this.patientRules.getPetTag(patient);
        }
        return result != null ? result : "";
    }

    public String getPatientRabiesTag(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getPatientRabiesTag(pointer.getValue());
    }

    public String getPatientRabiesTag(Object object) {
        String result = null;
        Party patient = this.patientFunctions.get(object);
        if (patient != null) {
            result = this.patientRules.getRabiesTag(patient);
        }
        return result != null ? result : "";
    }

    public String getPatientWeight(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getPatientWeight(pointer.getValue());
    }

    public String getPatientWeight(Object object) {
        String result = null;
        Party patient = this.patientFunctions.get(object);
        if (patient != null) {
            result = this.patientRules.getPatientWeight(patient);
        }
        return result != null ? result : "";
    }

    public BigDecimal getWeight(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getWeight(pointer.getValue());
    }

    public BigDecimal getWeight(Object object) {
        return this.patientFunctions.weight(this.patientFunctions.get(object));
    }

    public BigDecimal getWeight(Object object, String units) {
        return this.patientFunctions.weight(this.patientFunctions.get(object), units);
    }

    public String getPatientDesexStatus(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getPatientDesexStatus(pointer.getValue());
    }

    public String getPatientDesexStatus(Object object) {
        Party patient = this.patientFunctions.get(object);
        return patient != null ? this.patientRules.getPatientDesexStatus(patient) : "";
    }

    public Act getPatientVisit(Party patient) {
        return this.patientFunctions.visit(patient);
    }

    public Party getPractice() {
        return this.partyRules.getPractice();
    }

    public String getPracticeAddress() {
        return this.getPracticeAddress(true);
    }

    public String getPracticeAddress(boolean singleLine) {
        return this.partyRules.getPracticeAddress(singleLine);
    }

    public String getPracticeTelephone() {
        return this.partyRules.getPracticeTelephone();
    }

    public String getPracticeFaxNumber() {
        return this.partyRules.getPracticeFaxNumber();
    }

    @Deprecated
    public String getBpayID(ExpressionContext context) {
        return this.getBpayId(context);
    }

    public String getBpayId(ExpressionContext context) {
        Pointer pointer = context.getContextNodePointer();
        return this.getBpayId(pointer.getValue());
    }

    public String getBpayId(Object object) {
        Party party = this.unwrapParty(object);
        return party != null ? this.partyRules.getBpayId(party) : null;
    }

    public Party getLetterheadContacts(Object object) {
        Party result = null;
        if ((object = FunctionHelper.unwrap((Object)object)) instanceof Party) {
            Reference contacts;
            Party party;
            result = party = (Party)object;
            IMObjectBean bean = this.service.getBean((IMObject)party);
            Entity letterhead = (Entity)bean.getTarget("letterhead", Entity.class);
            if (letterhead != null && (contacts = (bean = this.service.getBean((IMObject)letterhead)).getTargetRef("contacts")) != null && !contacts.equals((Object)party.getObjectReference())) {
                result = (Party)this.service.get(contacts);
            }
        }
        return result;
    }

    public Iterable<Act> getAppointments(Party party, int interval, String units) {
        if (interval > 0 && units != null) {
            if (TypeHelper.isA((IMObject)party, (String)"party.customerperson")) {
                return this.appointmentRules.getPendingCustomerAppointments(party, interval, DateUnits.valueOf(units));
            }
            return this.patientFunctions.appointments(party, interval, units);
        }
        return Collections.emptyList();
    }

    private Party unwrapParty(Object object) {
        Party party = null;
        if ((object = FunctionHelper.unwrap((Object)object)) instanceof Act) {
            party = this.getCustomer((Act)object);
        } else if (object instanceof Party) {
            party = (Party)object;
        }
        return party;
    }

    private Party getCustomer(Act act) {
        IMObjectBean bean;
        Party customer = null;
        if (act != null && (customer = (Party)(bean = this.service.getBean((IMObject)act)).getTarget((Collection)act.getParticipations(), Party.class, CUSTOMER_PARTICIPATION)) == null) {
            customer = this.patientRules.getOwner(act);
        }
        return customer;
    }
}

