/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.document;

import org.openvpms.archetype.rules.doc.LongTextReader;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.NodeResolver;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.FunctionHelper;
import org.openvpms.component.system.common.util.PropertyState;

public class DocumentFunctions {
    private final IArchetypeService service;
    private final LookupService lookups;
    private final LongTextReader reader;

    public DocumentFunctions(IArchetypeService service, LookupService lookups) {
        this.service = service;
        this.lookups = lookups;
        this.reader = new LongTextReader((ArchetypeService)service);
    }

    public String text(Object object, String node) {
        PropertyState state = this.getState(object, node);
        String result = this.getText(state);
        if (result == null && state != null && state.getParent() instanceof DocumentAct) {
            result = this.reader.getText((DocumentAct)state.getParent());
        }
        return result;
    }

    public String text(Object object, String node, String relationshipNode) {
        DocumentAct act;
        IMObjectBean bean;
        PropertyState state = this.getState(object, node);
        String result = this.getText(state);
        if (result == null && state != null && state.getParent() != null && (bean = this.service.getBean(state.getParent())).hasNode(relationshipNode) && (act = (DocumentAct)bean.getTarget(relationshipNode, DocumentAct.class)) != null) {
            result = this.reader.getText(act);
        }
        return result;
    }

    private PropertyState getState(Object object, String node) {
        PropertyState result = null;
        if ((object = FunctionHelper.unwrap((Object)object)) instanceof IMObject) {
            NodeResolver resolver = new NodeResolver((IMObject)object, (ArchetypeService)this.service, this.lookups);
            result = resolver.resolve(node);
        }
        return result;
    }

    private String getText(PropertyState state) {
        Object value;
        String result = null;
        if (state != null && (value = state.getValue()) != null) {
            result = value.toString();
        }
        return result;
    }
}

