/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.stringparsers.BooleanStringParser;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.etl.tools.doc.DefaultDocumentFactory;
import org.openvpms.etl.tools.doc.DefaultLoadContext;
import org.openvpms.etl.tools.doc.DefaultLoaderListener;
import org.openvpms.etl.tools.doc.DocumentLoaderException;
import org.openvpms.etl.tools.doc.FileStrategy;
import org.openvpms.etl.tools.doc.IdLoader;
import org.openvpms.etl.tools.doc.Loader;
import org.openvpms.etl.tools.doc.LoaderListener;
import org.openvpms.etl.tools.doc.LoggingLoaderListener;
import org.openvpms.etl.tools.doc.NameLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

public class DocumentLoader {
    private final Loader loader;
    private final LoaderListener listener;
    private boolean failOnError = true;
    private String contextPath;
    private ApplicationContext context;
    static final Logger log = LoggerFactory.getLogger(DocumentLoader.class);
    private static final String APPLICATION_CONTEXT = "applicationContext.xml";

    public DocumentLoader(Loader loader, LoaderListener listener) {
        this.loader = loader;
        this.listener = listener;
    }

    protected DocumentLoader(String[] args, IArchetypeService service, PlatformTransactionManager transactionManager) {
        this(args, DocumentLoader.createParser(), service, transactionManager);
    }

    protected DocumentLoader(String[] args, JSAP parser) {
        this(args, parser, null, null);
    }

    protected DocumentLoader(String[] args, JSAP parser, IArchetypeService service, PlatformTransactionManager transactionManager) {
        JSAPResult config = parser.parse(args);
        boolean byId = config.getBoolean("byid");
        boolean byName = config.getBoolean("byname");
        if (!config.success()) {
            String message = null;
            Iterator iter = config.getErrorMessageIterator();
            if (iter.hasNext()) {
                message = iter.next().toString();
            }
            throw new DocumentLoaderException(DocumentLoaderException.ErrorCode.InvalidArguments, message);
        }
        if (!byId && !byName) {
            throw new DocumentLoaderException(DocumentLoaderException.ErrorCode.InvalidArguments, "One of --byid or --byname must be specified");
        }
        File source = config.getFile("source");
        File target = config.getFile("dest");
        File error = config.getFile("err");
        this.checkDirs(source, target, error);
        boolean rename = config.getBoolean("rename");
        this.contextPath = config.getString("context");
        if (service == null) {
            service = (IArchetypeService)this.getContext().getBean("archetypeService");
        }
        DefaultDocumentFactory factory = new DefaultDocumentFactory(service);
        this.listener = config.getBoolean("verbose") ? new LoggingLoaderListener(log) : new DefaultLoaderListener();
        String[] type = config.getStringArray("type");
        boolean recurse = config.getBoolean("recurse");
        boolean overwrite = config.getBoolean("overwrite");
        if (transactionManager == null) {
            transactionManager = (PlatformTransactionManager)this.getContext().getBean(PlatformTransactionManager.class);
        }
        FileStrategy fileStrategy = new FileStrategy(target, error, rename);
        DefaultLoadContext context = new DefaultLoadContext(fileStrategy, this.listener);
        if (byId) {
            String regexp = config.getString("regexp");
            Pattern pattern = Pattern.compile(regexp);
            this.loader = new IdLoader(source, type, service, factory, transactionManager, recurse, overwrite, pattern, context);
        } else {
            this.loader = new NameLoader(source, type, service, factory, transactionManager, recurse, overwrite, context);
        }
        this.setFailOnError(config.getBoolean("failOnError"));
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void load() {
        Date start = new Date();
        log.info("Starting load at: {}", (Object)start);
        while (this.loader.hasNext() && (this.loader.loadNext() || !this.failOnError)) {
        }
        this.dumpStats(start);
    }

    public static void main(String[] args) {
        JSAP parser = null;
        try {
            parser = DocumentLoader.createParser();
            DocumentLoader loader = new DocumentLoader(args, parser);
            loader.load();
        }
        catch (DocumentLoaderException exception) {
            if (exception.getMessage() != null) {
                System.err.println(exception.getMessage());
            }
            if (parser != null) {
                System.err.println("Usage: java " + DocumentLoader.class.getName());
                System.err.println("                " + parser.getUsage());
                System.err.println();
                System.err.println(parser.getHelp());
            } else {
                log.error(exception.getMessage(), (Throwable)((Object)exception));
            }
            System.exit(1);
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
            System.exit(1);
        }
    }

    private ApplicationContext getContext() {
        if (this.context == null) {
            this.context = !new File(this.contextPath).exists() ? new ClassPathXmlApplicationContext(this.contextPath) : new FileSystemXmlApplicationContext(this.contextPath);
        }
        return this.context;
    }

    private void checkDirs(File source, File target, File error) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 'source' is null");
        }
        if (target != null) {
            if (target.equals(source)) {
                throw new DocumentLoaderException(DocumentLoaderException.ErrorCode.SourceTargetSame, new Object[0]);
            }
            if (this.isSubdir(source, target)) {
                throw new DocumentLoaderException(DocumentLoaderException.ErrorCode.TargetChildOfSource, new Object[0]);
            }
        }
        if (error != null) {
            if (error.equals(source)) {
                throw new DocumentLoaderException(DocumentLoaderException.ErrorCode.SourceErrorSame, new Object[0]);
            }
            if (this.isSubdir(source, error)) {
                throw new DocumentLoaderException(DocumentLoaderException.ErrorCode.ErrorChildOfSource, new Object[0]);
            }
        }
    }

    private boolean isSubdir(File source, File dir) {
        for (File parent = dir.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(source)) continue;
            return true;
        }
        return false;
    }

    private void dumpStats(Date start) {
        Date end = new Date();
        log.info("Ending load at: {}", (Object)end);
        double elapsed = (double)(end.getTime() - start.getTime()) / 1000.0;
        int total = this.listener.getProcessed();
        double rate = elapsed != 0.0 ? (double)total / elapsed : 0.0;
        log.info("Loaded: {}", (Object)this.listener.getLoaded());
        log.info("Errors: {}", (Object)this.listener.getErrors());
        log.info("Total:  {}", (Object)total);
        if (log.isInfoEnabled()) {
            log.info(String.format("Processed %d files in %.2f seconds (%.2f files/sec)", total, elapsed, rate));
        }
    }

    private static JSAP createParser() {
        JSAP parser = new JSAP();
        FileStringParser dirParser = FileStringParser.getParser();
        dirParser.setMustBeDirectory(true);
        dirParser.setMustExist(true);
        try {
            parser.registerParameter(new Switch("byid").setShortFlag('i').setLongFlag("byid").setHelp("Load files using the identifiers in their names"));
            parser.registerParameter(new Switch("byname").setShortFlag('n').setLongFlag("byname").setHelp("Load files by matching their names with document acts"));
            parser.registerParameter(new FlaggedOption("source").setShortFlag('s').setLongFlag("source").setStringParser((StringParser)dirParser).setDefault("./").setHelp("The directory to load files from. "));
            parser.registerParameter(new Switch("recurse").setShortFlag('r').setLongFlag("recurse").setDefault("false").setHelp("Recursively scan the source directory"));
            parser.registerParameter(new Switch("overwrite").setShortFlag('o').setLongFlag("overwrite").setDefault("false").setHelp("Overwrite existing attachments"));
            parser.registerParameter(new FlaggedOption("regexp").setLongFlag("regexp").setDefault("[^\\d]*(\\d+).*").setHelp("Regular expression for parsing identifiers from file names. Only applies when --byid is used"));
            parser.registerParameter(new FlaggedOption("dest").setShortFlag('d').setLongFlag("dest").setStringParser((StringParser)dirParser).setHelp("The directory to move files to on successful load."));
            parser.registerParameter(new FlaggedOption("err").setLongFlag("err").setStringParser((StringParser)dirParser).setHelp("The directory to move files to on error."));
            parser.registerParameter(new FlaggedOption("type").setShortFlag('t').setLongFlag("type").setDefault(new String[]{"act.*Document*", "act.patientInvestigation"}).setAllowMultipleDeclarations(true).setHelp("The archetype short name. May contain wildcards."));
            parser.registerParameter(new FlaggedOption("failOnError").setShortFlag('e').setLongFlag("failOnError").setDefault("false").setStringParser((StringParser)BooleanStringParser.getParser()).setHelp("Fail on error"));
            parser.registerParameter(new Switch("rename").setLongFlag("rename").setDefault("false").setHelp("Rename files on move if a file already exists."));
            parser.registerParameter(new Switch("verbose").setShortFlag('v').setLongFlag("verbose").setDefault("false").setHelp("Displays verbose info to the console."));
            parser.registerParameter(new FlaggedOption("context").setShortFlag('c').setLongFlag("context").setDefault(APPLICATION_CONTEXT).setHelp("Application context path"));
        }
        catch (JSAPException exception) {
            throw new DocumentLoaderException(DocumentLoaderException.ErrorCode.FailedToCreateParser, exception, new Object[0]);
        }
        return parser;
    }
}

