/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.archetype.comparator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openvpms.component.model.archetype.ActionTypeDescriptor;
import org.openvpms.component.model.archetype.AssertionTypeDescriptor;
import org.openvpms.tools.archetype.comparator.AbstractComparator;
import org.openvpms.tools.archetype.comparator.ActionTypeChange;
import org.openvpms.tools.archetype.comparator.AssertionTypeChange;
import org.openvpms.tools.archetype.comparator.AssertionTypeFieldChange;

public class AssertionTypeComparator
extends AbstractComparator {
    public AssertionTypeChange compare(AssertionTypeDescriptor oldVersion, AssertionTypeDescriptor newVersion) {
        AssertionTypeChange result;
        if (oldVersion != null && newVersion != null) {
            ArrayList<AssertionTypeFieldChange> fieldChanges = new ArrayList<AssertionTypeFieldChange>();
            if (!Objects.equals(oldVersion.getName(), newVersion.getName())) {
                fieldChanges.add(new AssertionTypeFieldChange(AssertionTypeFieldChange.Field.NAME, oldVersion.getName(), newVersion.getName()));
            } else if (!Objects.equals(oldVersion.getPropertyArchetype(), newVersion.getPropertyArchetype())) {
                fieldChanges.add(new AssertionTypeFieldChange(AssertionTypeFieldChange.Field.PROPERTY_ARCHETYPE, oldVersion.getPropertyArchetype(), newVersion.getPropertyArchetype()));
            }
            List<ActionTypeChange> actionTypeChanges = this.getActionTypeChanges(oldVersion, newVersion);
            result = fieldChanges.isEmpty() && actionTypeChanges.isEmpty() ? null : new AssertionTypeChange(oldVersion, newVersion, fieldChanges, actionTypeChanges);
        } else {
            result = oldVersion == null && newVersion == null ? null : new AssertionTypeChange(oldVersion, newVersion, Collections.emptyList(), Collections.emptyList());
        }
        return result;
    }

    private List<ActionTypeChange> getActionTypeChanges(AssertionTypeDescriptor oldVersion, AssertionTypeDescriptor newVersion) {
        ArrayList<ActionTypeChange> result = new ArrayList<ActionTypeChange>();
        Map oldActionTypes = this.toMap(oldVersion.getActionTypes());
        Map newActionTypes = this.toMap(newVersion.getActionTypes());
        Set<String> added = this.getAdded(oldActionTypes, newActionTypes);
        Set<String> deleted = this.getDeleted(oldActionTypes, newActionTypes);
        Set<String> retained = this.getRetained(oldActionTypes, newActionTypes);
        for (String addedType : added) {
            result.add(new ActionTypeChange(null, (ActionTypeDescriptor)newActionTypes.get(addedType)));
        }
        for (String deletedType : deleted) {
            result.add(new ActionTypeChange((ActionTypeDescriptor)oldActionTypes.get(deletedType), null));
        }
        for (String retainedType : retained) {
            ActionTypeDescriptor newType;
            ActionTypeDescriptor oldType = (ActionTypeDescriptor)oldActionTypes.get(retainedType);
            if (this.same(oldType, newType = (ActionTypeDescriptor)newActionTypes.get(retainedType))) continue;
            result.add(new ActionTypeChange(oldType, newType));
        }
        return result;
    }

    private boolean same(ActionTypeDescriptor oldVersion, ActionTypeDescriptor newVersion) {
        return Objects.equals(oldVersion.getClassName(), newVersion.getClassName()) || Objects.equals(oldVersion.getMethodName(), newVersion.getMethodName());
    }
}

