/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query.criteria;

import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.criteria.Path;
import org.openvpms.component.system.common.query.criteria.Context;
import org.openvpms.component.system.common.query.criteria.ExpressionImpl;
import org.openvpms.component.system.common.query.criteria.Type;

public class PathImpl<X>
extends ExpressionImpl<X>
implements Path<X> {
    private final PathImpl<?> parent;

    public PathImpl(Type<X> type, PathImpl<?> parent, Context context) {
        super(type, context);
        this.parent = parent;
    }

    @Override
    public Path<X> alias(String alias) {
        return (Path)super.alias(alias);
    }

    public <Y> PathImpl<Y> get(String name) {
        Context context = this.getContext();
        Type type = context.getTypeForNode(this.getType(), name);
        return new PathImpl(type, this, context);
    }

    public <Y> Path<Y> get(String name, Class<Y> type) {
        Path path = this.get(name);
        if (!type.isAssignableFrom(path.getJavaType())) {
            throw new IllegalArgumentException("Node " + name + " has type: " + type);
        }
        return path;
    }

    public Path<Reference> reference() {
        if (IMObject.class.isAssignableFrom(this.getJavaType())) {
            Type<Reference> type = new Type<Reference>(Reference.class, null, null);
            return new PathImpl<Reference>(type, this, this.getContext());
        }
        return null;
    }

    public PathImpl<?> getParent() {
        return this.parent;
    }

    public String getName() {
        NodeDescriptor node = this.getNode();
        return node != null ? node.getName() : null;
    }

    public NodeDescriptor getNode() {
        return this.getType().getNode();
    }

    public boolean isReference() {
        return Reference.class.isAssignableFrom(this.getJavaType());
    }
}

