/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import java.util.List;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;

public class TupleImpl
implements Tuple {
    private final List<TupleElement<?>> elements;
    private final Object[] values;

    public TupleImpl(List<TupleElement<?>> elements, Object[] values) {
        this.elements = elements;
        this.values = values;
    }

    public <X> X get(TupleElement<X> element) {
        int index = this.elements.indexOf(element);
        if (index == -1) {
            throw new IllegalArgumentException("Argument 'element' does not correspond to an element in the tuple");
        }
        return (X)this.values[index];
    }

    public <X> X get(String alias, Class<X> type) {
        return type.cast(this.get(alias));
    }

    public Object get(String alias) {
        int index = 0;
        for (TupleElement<?> element : this.elements) {
            if (alias.equals(element.getAlias())) {
                return this.values[index];
            }
            ++index;
        }
        throw new IllegalArgumentException("Argument 'alias' does not correspond to an element in the tuple: " + alias);
    }

    public <X> X get(int i, Class<X> type) {
        return type.cast(this.get(i));
    }

    public Object get(int i) {
        if (i > this.values.length) {
            throw new IllegalArgumentException("Argument 'i' exceeds the length of the result tuple");
        }
        return this.values[i];
    }

    public Object[] toArray() {
        return this.values;
    }

    public List<TupleElement<?>> getElements() {
        return this.elements;
    }
}

