/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.ruleengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.rules.admin.RuleExecutionSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.ruleengine.BaseRuleSource;
import org.openvpms.component.business.service.ruleengine.RuleEngineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryRuleSource
extends BaseRuleSource {
    private String directory;
    private Map<String, String> ruleSetNames = new HashMap<String, String>();
    private Map providerProperties;
    private Map rulesetProperties;
    private Map registrationProperties;
    private static final Logger log = LoggerFactory.getLogger(DirectoryRuleSource.class);

    public void setProviderProperties(Map providerProperties) {
        this.providerProperties = providerProperties;
    }

    public void setRegistrationProperties(Map registrationProperties) {
        this.registrationProperties = registrationProperties;
    }

    public void setRulesetProperties(Map rulesetProperties) {
        this.rulesetProperties = rulesetProperties;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public boolean hasRuleExecutionSet(String uri) {
        return this.ruleSetNames.containsKey(uri);
    }

    protected void registerRuleExecutionSets() throws RuleEngineException {
        if (StringUtils.isEmpty((CharSequence)this.directory)) {
            throw new RuleEngineException(RuleEngineException.ErrorCode.NoDirSpecified);
        }
        File dir = FileUtils.toFile((URL)Thread.currentThread().getContextClassLoader().getResource(this.directory));
        if (dir == null) {
            throw new RuleEngineException(RuleEngineException.ErrorCode.InvalidDir, this.directory);
        }
        if (log.isDebugEnabled()) {
            log.debug("The base rules directory is " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new RuleEngineException(RuleEngineException.ErrorCode.InvalidDir, this.directory);
        }
        Collection collection = FileUtils.listFiles((File)dir, (String[])new String[]{"drl"}, (boolean)true);
        for (Object object : collection) {
            File file = (File)object;
            if (log.isDebugEnabled()) {
                log.debug("Registering the rule set in " + file.getAbsolutePath());
            }
            this.registerRuleExecutionSet(file);
        }
    }

    private void registerRuleExecutionSet(File file) {
        if (!file.exists()) {
            throw new RuleEngineException(RuleEngineException.ErrorCode.InvalidFile, file.getName());
        }
        try {
            RuleExecutionSet ruleExecutionSet = this.ruleAdministrator.getLocalRuleExecutionSetProvider(this.providerProperties).createRuleExecutionSet((InputStream)new FileInputStream(file), this.rulesetProperties);
            String uri = ruleExecutionSet.getName();
            this.ruleAdministrator.registerRuleExecutionSet(uri, ruleExecutionSet, this.registrationProperties);
            this.ruleSetNames.put(uri, file.getName());
        }
        catch (Exception exception) {
            throw new RuleEngineException(RuleEngineException.ErrorCode.FailedToRegister, exception, file.getName());
        }
    }
}

