/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.Objects;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.AbstractMonitoringIMObjectCache;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;

public class SingletonIMObjectCache<T extends IMObject>
extends AbstractMonitoringIMObjectCache<T> {
    private T singleton;

    public SingletonIMObjectCache(IArchetypeService service, String archetype, Class<T> type) {
        super(service, archetype, type);
        this.loadFirst();
    }

    public synchronized T getObject() {
        if (this.singleton == null) {
            this.loadFirst();
        }
        return this.singleton;
    }

    @Override
    protected synchronized T addObject(T object) {
        T result = null;
        if (!((IMObject)object).isActive()) {
            this.removeObject(object);
        } else if (this.singleton == null || ((IMObject)this.singleton).equals(object) && ((IMObject)this.singleton).getVersion() <= ((IMObject)object).getVersion() || ((IMObject)this.singleton).getId() > ((IMObject)object).getId()) {
            this.singleton = object;
            this.updated(this.singleton);
            result = this.singleton;
        }
        return result;
    }

    @Override
    protected synchronized void removeObject(T object) {
        if (Objects.equals(this.singleton, object)) {
            this.singleton = null;
            this.updated(null);
        }
    }

    protected void updated(T object) {
    }

    private void loadFirst() {
        ArchetypeQuery query = new ArchetypeQuery(this.getArchetypes(), true, true);
        query.add(Constraints.sort("id"));
        IMObjectQueryIterator iter = new IMObjectQueryIterator(this.getService(), query);
        if (iter.hasNext()) {
            this.addObject((T)((IMObject)iter.next()));
        }
    }
}

