/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public final class DescriptorHelper {
    private DescriptorHelper() {
    }

    public static ArchetypeDescriptor getArchetypeDescriptor(String shortName, ArchetypeService service) {
        return (ArchetypeDescriptor)service.getArchetypeDescriptor(shortName);
    }

    public static ArchetypeDescriptor getArchetypeDescriptor(Reference reference, ArchetypeService service) {
        return DescriptorHelper.getArchetypeDescriptor(reference.getArchetype(), service);
    }

    public static ArchetypeDescriptor getArchetypeDescriptor(IMObject object, ArchetypeService service) {
        return (ArchetypeDescriptor)service.getArchetypeDescriptor(object.getArchetype());
    }

    public static List<org.openvpms.component.model.archetype.ArchetypeDescriptor> getArchetypeDescriptors(String shortName, ArchetypeService service) {
        return DescriptorHelper.getArchetypeDescriptors(new String[]{shortName}, service);
    }

    public static List<org.openvpms.component.model.archetype.ArchetypeDescriptor> getArchetypeDescriptors(String[] range, ArchetypeService service) {
        ArrayList<org.openvpms.component.model.archetype.ArchetypeDescriptor> result = new ArrayList<org.openvpms.component.model.archetype.ArchetypeDescriptor>();
        for (String shortName : range) {
            result.addAll(service.getArchetypeDescriptors(shortName));
        }
        return result;
    }

    public static String[] getShortNames(org.openvpms.component.model.archetype.NodeDescriptor descriptor, ArchetypeService service) {
        String[] names = DescriptorHelper.getShortNames(descriptor.getArchetypeRange(), false, service);
        if (names.length == 0 && !StringUtils.isEmpty((CharSequence)descriptor.getFilter())) {
            names = DescriptorHelper.getShortNames(descriptor.getFilter(), false, service);
        }
        return names;
    }

    public static String[] getShortNames(String shortName, ArchetypeService service) {
        return DescriptorHelper.getShortNames(shortName, true, service);
    }

    public static String[] getShortNames(String shortName, boolean primaryOnly, ArchetypeService service) {
        return DescriptorHelper.getShortNames(new String[]{shortName}, primaryOnly, service);
    }

    public static String[] getShortNames(String[] shortNames, ArchetypeService service) {
        return DescriptorHelper.getShortNames(shortNames, true, service);
    }

    public static String[] getShortNames(String[] shortNames, boolean primaryOnly, ArchetypeService service) {
        LinkedHashSet result = new LinkedHashSet();
        for (String shortName : shortNames) {
            List matches = service.getArchetypes(shortName, primaryOnly);
            result.addAll(matches);
        }
        return result.toArray(new String[0]);
    }

    public static String[] getNodeShortNames(String shortName, String node, ArchetypeService service) {
        return DescriptorHelper.getNodeShortNames(new String[]{shortName}, node, service);
    }

    public static String[] getNodeShortNames(String[] shortNames, String node, ArchetypeService service) {
        String[] expanded;
        LinkedHashSet<String> matches = new LinkedHashSet<String>();
        for (String shortName : expanded = DescriptorHelper.getShortNames(shortNames, false, service)) {
            NodeDescriptor desc;
            ArchetypeDescriptor archetype = DescriptorHelper.getArchetypeDescriptor(shortName, service);
            if (archetype == null || (desc = archetype.getNodeDescriptor(node)) == null) continue;
            matches.addAll(Arrays.asList(DescriptorHelper.getShortNames(desc, service)));
        }
        return matches.toArray(new String[0]);
    }

    public static String getDisplayName(String shortName, ArchetypeService service) {
        ArchetypeDescriptor descriptor = DescriptorHelper.getArchetypeDescriptor(shortName, service);
        return descriptor != null ? descriptor.getDisplayName() : null;
    }

    public static String getDisplayName(IMObject object, ArchetypeService service) {
        ArchetypeDescriptor descriptor = DescriptorHelper.getArchetypeDescriptor(object, service);
        return descriptor != null ? descriptor.getDisplayName() : null;
    }

    public static String getDisplayName(IMObject object, String node, ArchetypeService service) {
        return DescriptorHelper.getDisplayName(object.getArchetype(), node, service);
    }

    public static String getDisplayName(String shortName, String node, ArchetypeService service) {
        NodeDescriptor descriptor;
        String result = null;
        ArchetypeDescriptor archetype = DescriptorHelper.getArchetypeDescriptor(shortName, service);
        if (archetype != null && (descriptor = archetype.getNodeDescriptor(node)) != null) {
            result = descriptor.getDisplayName();
        }
        return result;
    }

    public static String[] getCommonNodeNames(String shortNames, ArchetypeService service) {
        return DescriptorHelper.getCommonNodeNames(shortNames, null, service);
    }

    public static String[] getCommonNodeNames(String[] shortNames, ArchetypeService service) {
        return DescriptorHelper.getCommonNodeNames(shortNames, null, service);
    }

    public static String[] getCommonNodeNames(String shortNames, String[] nodes, ArchetypeService service) {
        return DescriptorHelper.getCommonNodeNames(new String[]{shortNames}, nodes, service);
    }

    public static String[] getCommonNodeNames(String[] shortNames, String[] nodes, ArchetypeService service) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        boolean init = false;
        if (nodes != null && nodes.length != 0) {
            result.addAll(Arrays.asList(nodes));
        } else {
            init = true;
        }
        for (org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor : DescriptorHelper.getArchetypeDescriptors(shortNames, service)) {
            if (init) {
                for (org.openvpms.component.model.archetype.NodeDescriptor nodeDescriptor : ((ArchetypeDescriptor)descriptor).getAllNodeDescriptors()) {
                    result.add(nodeDescriptor.getName());
                }
                init = false;
                continue;
            }
            result.removeIf(node -> descriptor.getNodeDescriptor(node) == null);
        }
        return result.toArray(new String[0]);
    }

    public static org.openvpms.component.model.archetype.NodeDescriptor getNode(String shortName, String node, ArchetypeService service) {
        ArchetypeDescriptor descriptor = DescriptorHelper.getArchetypeDescriptor(shortName, service);
        return descriptor != null ? descriptor.getNodeDescriptor(node) : null;
    }
}

