/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.business.service.archetype.helper.PropertyResolver;
import org.openvpms.component.business.service.archetype.helper.PropertyResolverException;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertion;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertionFactory;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertyState;

public abstract class BasePropertyResolver
implements PropertyResolver {
    private final ArchetypeService service;
    private final LookupService lookups;

    protected BasePropertyResolver(ArchetypeService service, LookupService lookups) {
        this.service = service;
        this.lookups = lookups;
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected LookupService getLookups() {
        return this.lookups;
    }

    protected List<Object> getObjects(org.openvpms.component.model.object.IMObject root, String name) {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<org.openvpms.component.model.object.IMObject> parents = new ArrayList<org.openvpms.component.model.object.IMObject>();
        if (StringUtils.isEmpty((CharSequence)name)) {
            result.add(root);
        } else {
            int index;
            parents.add(root);
            while ((index = name.indexOf(".")) != -1) {
                ArrayList<org.openvpms.component.model.object.IMObject> children = new ArrayList<org.openvpms.component.model.object.IMObject>();
                ArchetypeDescriptor archetype = null;
                for (org.openvpms.component.model.object.IMObject parent : parents) {
                    String node;
                    archetype = this.getArchetype(parent, archetype);
                    NodeDescriptor descriptor = this.getNode(archetype, node = name.substring(0, index));
                    if (descriptor.isCollection()) {
                        children.addAll(descriptor.getValues(parent));
                        continue;
                    }
                    Object child = this.getValue(parent, descriptor, true);
                    if (child == null) continue;
                    if (child instanceof org.openvpms.component.model.object.IMObject) {
                        children.add((org.openvpms.component.model.object.IMObject)child);
                        continue;
                    }
                    throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidProperty, name);
                }
                parents = children;
                name = name.substring(index + 1);
            }
            ArchetypeDescriptor archetype = null;
            Iterator iterator = parents.iterator();
            while (iterator.hasNext()) {
                org.openvpms.component.model.object.IMObject object;
                NodeDescriptor leafNode = (archetype = this.getArchetype(object = (org.openvpms.component.model.object.IMObject)iterator.next(), archetype)) != null ? archetype.getNodeDescriptor(name) : null;
                Object value = this.getLeafValue(object, name, archetype, leafNode);
                if (value == null) continue;
                if (value instanceof Collection) {
                    result.addAll((Collection)value);
                    continue;
                }
                result.add(value);
            }
        }
        return result;
    }

    protected PropertyState getLeafPropertyState(org.openvpms.component.model.object.IMObject object, String name, ArchetypeDescriptor archetype) {
        NodeDescriptor leafNode = archetype != null ? archetype.getNodeDescriptor(name) : null;
        Object value = this.getLeafValue(object, name, archetype, leafNode);
        return new PropertyState(object, archetype, name, leafNode, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getLeafValue(org.openvpms.component.model.object.IMObject object, String name, ArchetypeDescriptor archetype, NodeDescriptor node) {
        if (node != null) return this.getValue(object, node, false);
        if ("displayName".equals(name) && archetype != null) {
            return archetype.getDisplayName();
        }
        if ("shortName".equals(name)) {
            return object.getArchetype();
        }
        if ("uid".equals(name)) {
            return object.getId();
        }
        if (!(object instanceof Lookup)) throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidProperty, name);
        if ("name".equals(name)) {
            return object.getName();
        }
        if (!"code".equals(name)) throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidNode, name, object.getArchetype());
        return ((Lookup)object).getCode();
    }

    protected Object getValue(org.openvpms.component.model.object.IMObject parent, NodeDescriptor descriptor, boolean resolveLookups) {
        Object result;
        if (descriptor.isObjectReference()) {
            result = this.resolve(parent, descriptor);
        } else if (descriptor.isCollection()) {
            List<IMObject> values = descriptor.getChildren(parent);
            int size = values.size();
            result = size == 0 ? null : (size == 1 ? values.get(0) : values);
        } else {
            result = descriptor.getValue(parent);
            if (result != null && resolveLookups && this.lookups != null && descriptor.isLookup()) {
                LookupAssertion assertion = LookupAssertionFactory.create(descriptor, this.service, this.lookups);
                result = assertion.getLookup(parent, result.toString());
            }
        }
        return result;
    }

    protected org.openvpms.component.model.object.IMObject resolve(Reference ref) {
        return ref != null ? this.service.get(ref) : null;
    }

    protected ArchetypeDescriptor getArchetype(org.openvpms.component.model.object.IMObject object, ArchetypeDescriptor existing) {
        if (existing != null && existing.getArchetypeType().equals(object.getArchetype())) {
            return existing;
        }
        return this.getArchetype(object);
    }

    protected ArchetypeDescriptor getArchetype(org.openvpms.component.model.object.IMObject object) {
        return (ArchetypeDescriptor)this.service.getArchetypeDescriptor(object.getArchetype());
    }

    protected NodeDescriptor getNode(ArchetypeDescriptor archetype, String name) {
        NodeDescriptor descriptor = archetype.getNodeDescriptor(name);
        if (descriptor == null) {
            throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidNode, name, archetype.getArchetypeType());
        }
        return descriptor;
    }

    private org.openvpms.component.model.object.IMObject resolve(org.openvpms.component.model.object.IMObject parent, NodeDescriptor descriptor) {
        Reference ref = (Reference)descriptor.getValue(parent);
        return this.resolve(ref);
    }
}

