/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.act.Act;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.common.Participation;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.CollectionNodeConstraint;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectRefNodeConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.RelationalOp;

public class ArchetypeQueryHelper {
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";

    private ArchetypeQueryHelper() {
    }

    public static IPage<Act> getActs(IArchetypeService service, IMObjectReference ref, String pShortName, String entityName, String aConceptName, Date startTimeFrom, Date startTimeThru, Date endTimeFrom, Date endTimeThru, String status, boolean activeOnly, int firstResult, int maxResults) {
        ArchetypeQuery query = new ArchetypeQuery(entityName, aConceptName, false, activeOnly).setFirstResult(firstResult).setMaxResults(maxResults).setCountResults(true);
        if (!StringUtils.isEmpty((CharSequence)status)) {
            query.add(new NodeConstraint("status", RelationalOp.EQ, status));
        }
        if (startTimeFrom != null || startTimeThru != null) {
            query.add(new NodeConstraint(START_TIME, RelationalOp.BTW, startTimeFrom, startTimeThru));
        }
        if (endTimeFrom != null || endTimeThru != null) {
            query.add(new NodeConstraint(END_TIME, RelationalOp.BTW, endTimeFrom, endTimeThru));
        }
        CollectionNodeConstraint participations = new CollectionNodeConstraint("participations", pShortName, false, activeOnly).add(new ObjectRefNodeConstraint("entity", ref));
        query.add(participations);
        return service.get(query);
    }

    public static IPage<Participation> getParticipations(IArchetypeService service, IMObjectReference ref, String shortName, Date startTimeFrom, Date startTimeThru, Date endTimeFrom, Date endTimeThru, boolean activeOnly, int firstResult, int maxResults) {
        ArchetypeQuery query = new ArchetypeQuery(shortName, false, activeOnly).add(new ObjectRefNodeConstraint("entity", ref)).setFirstResult(firstResult).setMaxResults(maxResults).setCountResults(true);
        if (startTimeFrom != null || startTimeThru != null) {
            query.add(new NodeConstraint(START_TIME, RelationalOp.BTW, startTimeFrom, startTimeThru));
        }
        if (endTimeFrom != null || endTimeThru != null) {
            query.add(new NodeConstraint(END_TIME, RelationalOp.BTW, endTimeFrom, endTimeThru));
        }
        return service.get(query);
    }

    public static IPage<Act> getActs(IArchetypeService service, String entityName, String conceptName, Date startTimeFrom, Date startTimeThru, Date endTimeFrom, Date endTimeThru, String status, boolean activeOnly, int firstResult, int maxResults) {
        ArchetypeQuery query = new ArchetypeQuery(entityName, conceptName, false, activeOnly).setFirstResult(firstResult).setMaxResults(maxResults).setCountResults(true);
        if (!StringUtils.isEmpty((CharSequence)status)) {
            query.add(new NodeConstraint("status", RelationalOp.EQ, status));
        }
        if (startTimeFrom != null || startTimeThru != null) {
            query.add(new NodeConstraint(START_TIME, RelationalOp.BTW, startTimeFrom, startTimeThru));
        }
        if (endTimeFrom != null || endTimeThru != null) {
            query.add(new NodeConstraint(END_TIME, RelationalOp.BTW, endTimeFrom, endTimeThru));
        }
        return service.get(query);
    }

    public static IPage<IMObject> get(IArchetypeService service, String entityName, String conceptName, String instanceName, boolean activeOnly, int firstResult, int maxResults) {
        ArchetypeQuery query = new ArchetypeQuery(entityName, conceptName, false, activeOnly).setFirstResult(firstResult).setMaxResults(maxResults).setCountResults(true);
        if (!StringUtils.isEmpty((CharSequence)instanceName)) {
            query.add(new NodeConstraint("name", instanceName));
        }
        return service.get(query);
    }

    public static IPage<IMObject> get(IArchetypeService service, String[] shortNames, boolean activeOnly, int firstResult, int maxResults) {
        ArchetypeQuery query = new ArchetypeQuery(shortNames, false, activeOnly).setFirstResult(firstResult).setMaxResults(maxResults).setCountResults(true);
        return service.get(query);
    }

    public static String getName(Reference reference, IArchetypeService service) {
        String result = null;
        if (reference != null) {
            ObjectRefConstraint constraint = new ObjectRefConstraint("o", reference);
            ArchetypeQuery query = new ArchetypeQuery(constraint);
            query.add(new NodeSelectConstraint("o.name"));
            query.setMaxResults(1);
            ObjectSetQueryIterator iter = new ObjectSetQueryIterator(service, query);
            if (iter.hasNext()) {
                ObjectSet set = (ObjectSet)iter.next();
                result = set.getString("o.name");
            }
        }
        return result;
    }
}

