/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.ValidationError;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.util.StringUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IMObjectValidator {
    private final IArchetypeDescriptorCache cache;
    private static final Logger log = LoggerFactory.getLogger(IMObjectValidator.class);

    public IMObjectValidator(IArchetypeDescriptorCache cache) {
        this.cache = cache;
    }

    public List<org.openvpms.component.service.archetype.ValidationError> validate(IMObject object) {
        ArrayList<org.openvpms.component.service.archetype.ValidationError> errors = new ArrayList<org.openvpms.component.service.archetype.ValidationError>();
        this.validate(object, errors);
        return errors;
    }

    protected void validate(IMObject object, List<org.openvpms.component.service.archetype.ValidationError> errors) {
        String archetype = object.getArchetype();
        log.debug("Validating object of type {} with id {} and version {}", new Object[]{archetype, object.getId(), object.getVersion()});
        ArchetypeDescriptor descriptor = this.cache.getArchetypeDescriptor(archetype);
        if (descriptor == null) {
            this.addError(errors, object, null, "No archetype definition for " + archetype);
            log.error("No archetype definition for {}", (Object)archetype);
        } else {
            Map<String, org.openvpms.component.model.archetype.NodeDescriptor> nodeDescriptors = descriptor.getNodeDescriptorMap();
            if (!nodeDescriptors.isEmpty()) {
                JXPathContext context = JXPathHelper.newContext(object);
                this.validateNodes(object, context, descriptor, nodeDescriptors, errors);
            }
        }
    }

    protected void validateNodes(IMObject parent, JXPathContext context, ArchetypeDescriptor archetype, Map<String, NodeDescriptor> nodes, List<org.openvpms.component.service.archetype.ValidationError> errors) {
        for (NodeDescriptor node : nodes.values()) {
            this.validateNode(parent, context, archetype, node, errors);
        }
    }

    protected void validateNode(IMObject parent, JXPathContext context, ArchetypeDescriptor archetype, NodeDescriptor node, List<org.openvpms.component.service.archetype.ValidationError> errors) {
        Object value;
        try {
            value = node.getValue(context);
        }
        catch (Exception exception) {
            this.addError(errors, parent, node, "Failed to get value");
            log.error("Failed to get value for {}", (Object)node.getName(), (Object)exception);
            return;
        }
        if (node.isDerived()) {
            try {
                context.getPointer(node.getPath()).setValue(value);
            }
            catch (Exception exception) {
                this.addError(errors, parent, node, "Cannot derive value");
                log.error("Failed to derive value for {}", (Object)node.getName(), (Object)exception);
                return;
            }
        }
        if (node.isCollection()) {
            this.checkCollection(parent, node, value, errors);
        } else {
            this.checkSimpleValue(parent, node, value, errors);
        }
        if (value != null) {
            this.checkAssertions(parent, node, value, errors);
        }
        if (!node.getNodeDescriptors().isEmpty()) {
            this.validateNodes(parent, context, archetype, node.getNodeDescriptors(), errors);
        }
    }

    protected void checkSimpleValue(IMObject parent, NodeDescriptor node, Object value, List<org.openvpms.component.service.archetype.ValidationError> errors) {
        int min = node.getMinCardinality();
        if (min == 1 && value == null) {
            this.addError(errors, parent, node, "value is required");
        } else if (value instanceof String) {
            String str = (String)value;
            if (min == 1 && StringUtils.isEmpty((CharSequence)str)) {
                this.addError(errors, parent, node, "value is required");
            } else {
                int length = str.length();
                int minLength = node.getMinLength();
                int maxLength = node.getMaxLength();
                if (length != 0 && length < minLength) {
                    this.addError(errors, parent, node, "String too short. At least " + minLength + " characters are required but only " + length + " were provided");
                } else if (maxLength > 0 && length > maxLength) {
                    this.addError(errors, parent, node, "String too long. Maximum length is " + maxLength + " characters but " + length + " were provided");
                } else {
                    this.checkInvalidCharacters(parent, node, str, errors);
                }
            }
        }
    }

    protected void checkCollection(IMObject parent, NodeDescriptor node, Object value, List<org.openvpms.component.service.archetype.ValidationError> errors) {
        Collection<?> collection = node.toCollection(value);
        this.checkMinCardinality(parent, node, collection, errors);
        if (collection != null) {
            this.checkMaxCardinality(parent, node, collection, errors);
            if (node.isParentChild()) {
                for (Object object : collection) {
                    if (!(object instanceof IMObject)) continue;
                    this.validate((IMObject)object, errors);
                }
            }
        }
    }

    protected void checkAssertions(IMObject parent, NodeDescriptor node, Object value, List<org.openvpms.component.service.archetype.ValidationError> errors) {
        for (AssertionDescriptor assertion : node.getAssertionDescriptorsAsArray()) {
            this.checkAssertion(parent, node, value, assertion, errors);
        }
    }

    protected void checkAssertion(IMObject parent, NodeDescriptor node, Object value, AssertionDescriptor assertion, List<org.openvpms.component.service.archetype.ValidationError> errors) {
        try {
            if (!assertion.validate(value, parent, node)) {
                String message = assertion.getErrorMessage();
                if (message == null) {
                    message = "Validation failed for assertion " + assertion.getName();
                }
                this.addError(errors, parent, node, message);
            }
        }
        catch (Exception exception) {
            log.error("Assertion {} failed for node {}", new Object[]{assertion.getName(), node, exception});
            this.addError(errors, parent, node, exception.getMessage());
        }
    }

    protected void checkInvalidCharacters(IMObject parent, NodeDescriptor node, String value, List<org.openvpms.component.service.archetype.ValidationError> errors) {
        if (StringUtilities.hasControlChars(value)) {
            this.addError(errors, parent, node, "contains invalid characters");
        } else if (StringUtilities.has4ByteUnicode(value)) {
            this.addError(errors, parent, node, "contains an unsupported unicode character");
        }
    }

    private void checkMinCardinality(IMObject parent, NodeDescriptor node, Collection<?> collection, List<org.openvpms.component.service.archetype.ValidationError> errors) {
        int min = node.getMinCardinality();
        if (min > 0 && (collection == null || collection.size() < min)) {
            String name = node.getBaseName() != null ? node.getBaseName() : "item";
            this.addError(errors, parent, node, "must supply at least " + min + " " + name);
        }
    }

    private void checkMaxCardinality(IMObject parent, NodeDescriptor node, Collection<?> collection, List<org.openvpms.component.service.archetype.ValidationError> errors) {
        int max = node.getMaxCardinality();
        if (max > 0 && collection.size() > max) {
            String name = node.getBaseName() != null ? node.getBaseName() : "item";
            this.addError(errors, parent, node, "cannot supply more than " + max + " " + name);
        }
    }

    private void addError(List<org.openvpms.component.service.archetype.ValidationError> errors, IMObject object, NodeDescriptor node, String message) {
        String archetype = object.getArchetype();
        String nodeName = node != null ? node.getName() : null;
        errors.add(new ValidationError(object.getObjectReference(), nodeName, message));
        log.debug("Validation failed: archetype={}, node={}, message={}", new Object[]{archetype, nodeName, message});
    }
}

