/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.archetype.descriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ArchetypeList
implements ArchetypeRange {
    public static final ArchetypeRange EMPTY = new ArchetypeList(Collections.emptyList());
    private final List<String> archetypes;
    private final String defaultArchetype;

    public ArchetypeList(String archetype) {
        this(archetype, null);
    }

    public ArchetypeList(String archetype, String defaultArchetype) {
        this(Collections.singletonList(archetype), defaultArchetype);
    }

    public ArchetypeList(String[] archetypes) {
        this(archetypes, null);
    }

    public ArchetypeList(String[] archetypes, String defaultArchetype) {
        this(Arrays.asList(archetypes), defaultArchetype);
    }

    public ArchetypeList(List<String> archetypes) {
        this(archetypes, null);
    }

    public ArchetypeList(List<String> archetypes, String defaultArchetype) {
        this.archetypes = archetypes;
        this.defaultArchetype = defaultArchetype;
    }

    public List<String> getArchetypes() {
        return this.archetypes;
    }

    public String getDefaultArchetype() {
        return this.defaultArchetype;
    }

    public static ArchetypeRange expand(ArchetypeRange range, ArchetypeService service) {
        String[] archetypes = DescriptorHelper.getShortNames(range.getArchetypes().toArray(new String[0]), false, service);
        return archetypes.length != 0 || range.getDefaultArchetype() != null ? new ArchetypeList(archetypes, range.getDefaultArchetype()) : EMPTY;
    }
}

