/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.archetype;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeIdException;

class ShortName {
    private final String entityName;
    private final String concept;
    private final String shortName;
    private static final Map<String, ShortName> cache = Collections.synchronizedMap(new ReferenceMap());

    private ShortName(String entityName, String concept, String shortName) {
        this.entityName = entityName;
        this.concept = concept;
        this.shortName = shortName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getConcept() {
        return this.concept;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortName)) {
            return false;
        }
        ShortName rhs = (ShortName)obj;
        return Objects.equals(this.shortName, rhs.getShortName());
    }

    public int hashCode() {
        return this.shortName.hashCode();
    }

    public static ShortName get(String shortName) {
        ShortName result = cache.get(shortName);
        if (result == null) {
            result = ShortName.parse(shortName);
            cache.put(shortName, result);
        }
        return result;
    }

    public static ShortName get(String entityName, String concept) {
        String shortName = entityName + "." + concept;
        return cache.computeIfAbsent(shortName, s -> new ShortName(entityName, concept, shortName));
    }

    private static ShortName parse(String shortName) {
        if (StringUtils.isEmpty((CharSequence)shortName)) {
            throw new ArchetypeIdException(ArchetypeIdException.ErrorCode.EmptyShortName);
        }
        StringTokenizer tokens = new StringTokenizer(shortName, ".");
        if (tokens.countTokens() != 2) {
            throw new ArchetypeIdException(ArchetypeIdException.ErrorCode.InvalidShortNameFormat, shortName);
        }
        String entityName = tokens.nextToken();
        String concept = tokens.nextToken();
        return new ShortName(entityName, concept, shortName);
    }
}

