/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.lookup;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.openvpms.component.business.dao.hibernate.im.act.ActDOImpl;
import org.openvpms.component.business.dao.hibernate.im.act.ActRelationshipDOImpl;
import org.openvpms.component.business.dao.hibernate.im.act.ParticipationDOImpl;
import org.openvpms.component.business.dao.hibernate.im.document.DocumentDOImpl;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityDOImpl;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityIdentityDOImpl;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityLinkDOImpl;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityRelationshipDOImpl;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupDOImpl;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupLinkDOImpl;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupRelationshipDOImpl;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupUsageFinder;
import org.openvpms.component.business.dao.hibernate.im.party.ContactDOImpl;
import org.openvpms.component.business.dao.hibernate.im.party.PartyDOImpl;
import org.openvpms.component.business.dao.hibernate.im.product.ProductDOImpl;
import org.openvpms.component.business.dao.hibernate.im.product.ProductPriceDOImpl;
import org.openvpms.component.business.dao.hibernate.im.security.UserDOImpl;
import org.openvpms.component.business.domain.im.act.Act;
import org.openvpms.component.business.domain.im.act.ActRelationship;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.Entity;
import org.openvpms.component.business.domain.im.common.EntityIdentity;
import org.openvpms.component.business.domain.im.common.EntityLink;
import org.openvpms.component.business.domain.im.common.EntityRelationship;
import org.openvpms.component.business.domain.im.common.Participation;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.business.domain.im.lookup.LookupLink;
import org.openvpms.component.business.domain.im.lookup.LookupRelationship;
import org.openvpms.component.business.domain.im.party.Contact;
import org.openvpms.component.business.domain.im.product.ProductPrice;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class LookupReplacer {
    private final IArchetypeDescriptorCache archetypes;
    private static final String ENTITY_CLASSIFICATIONS_SELECT;
    private static final String ENTITY_CLASSIFICATIONS_UPDATE;
    private static final String ENTITY_CLASSIFICATIONS_DELETE;
    private static final String CONTACT_CLASSIFICATIONS_SELECT;
    private static final String CONTACT_CLASSIFICATIONS_UPDATE;
    private static final String CONTACT_CLASSIFICATIONS_DELETE;
    private static final String PRICE_CLASSIFICATIONS_SELECT;
    private static final String PRICE_CLASSIFICATIONS_UPDATE;
    private static final String PRICE_CLASSIFICATIONS_DELETE;
    private static final Map<Class<?>, Mapping> mappings;
    private static final String ENTITY_CLASSIFICATIONS = "entity_classifications";
    private static final String CONTACT_CLASSIFICATIONS = "contact_classifications";
    private static final String PRODUCT_PRICE_CLASSIFICATIONS = "product_price_classifications";

    public LookupReplacer(IArchetypeDescriptorCache archetypes) {
        this.archetypes = archetypes;
    }

    public boolean isUsed(org.openvpms.component.model.lookup.Lookup lookup, Session session) {
        if (this.isClassificationInUse(lookup, ENTITY_CLASSIFICATIONS_SELECT, session) || this.isClassificationInUse(lookup, CONTACT_CLASSIFICATIONS_SELECT, session) || this.isClassificationInUse(lookup, PRICE_CLASSIFICATIONS_SELECT, session) || this.isLinkTarget(lookup, session)) {
            return true;
        }
        LookupUsageFinder finder = new LookupUsageFinder(this.archetypes);
        Map<NodeDescriptor, ArchetypeDescriptor> refs = finder.getCodeReferences(lookup.getArchetype());
        for (Map.Entry<NodeDescriptor, ArchetypeDescriptor> entry : refs.entrySet()) {
            NodeDescriptor node = entry.getKey();
            ArchetypeDescriptor archetype = entry.getValue();
            if (!(this.isDetailsNode(node) ? this.isUsedSQL(lookup, node, archetype, session) : this.isUsedHQL(lookup, node, archetype, session))) continue;
            return true;
        }
        return false;
    }

    public void replace(org.openvpms.component.model.lookup.Lookup source, org.openvpms.component.model.lookup.Lookup target, Session session) {
        if (source.getId() == target.getId()) {
            throw new IllegalArgumentException("Source and target lookups are identical");
        }
        if (!source.getArchetype().equals(target.getArchetype())) {
            throw new IllegalArgumentException("Source and target lookups must have the same archetype");
        }
        LookupUsageFinder finder = new LookupUsageFinder(this.archetypes);
        Map<NodeDescriptor, ArchetypeDescriptor> refs = finder.getCodeReferences(source.getArchetype());
        for (Map.Entry<NodeDescriptor, ArchetypeDescriptor> entry : refs.entrySet()) {
            NodeDescriptor node = entry.getKey();
            ArchetypeDescriptor archetype = entry.getValue();
            if (this.isDetailsNode(node)) {
                this.replaceCodeSQL(node, archetype, source, target, session);
                continue;
            }
            this.replaceCodeHQL(node, archetype, source, target, session);
        }
        this.replaceClassifications(source, target, ENTITY_CLASSIFICATIONS_UPDATE, ENTITY_CLASSIFICATIONS_DELETE, session, EntityDOImpl.class, PartyDOImpl.class, ProductDOImpl.class, UserDOImpl.class);
        this.replaceClassifications(source, target, CONTACT_CLASSIFICATIONS_UPDATE, CONTACT_CLASSIFICATIONS_DELETE, session, ContactDOImpl.class);
        this.replaceClassifications(source, target, PRICE_CLASSIFICATIONS_UPDATE, PRICE_CLASSIFICATIONS_DELETE, session, ProductPriceDOImpl.class);
    }

    private boolean isUsedSQL(org.openvpms.component.model.lookup.Lookup lookup, NodeDescriptor node, ArchetypeDescriptor archetype, Session session) {
        Mapping mapping = this.getMapping(archetype, node);
        NativeQuery query = session.createSQLQuery(mapping.getIsUsedSQL());
        query.setMaxResults(1);
        query.setParameter("archetype", (Object)archetype.getType().getShortName());
        query.setParameter("name", (Object)node.getName());
        query.setParameter("code", (Object)lookup.getCode());
        return !query.list().isEmpty();
    }

    private boolean isUsedHQL(org.openvpms.component.model.lookup.Lookup lookup, NodeDescriptor node, ArchetypeDescriptor archetype, Session session) {
        Mapping mapping = this.getMapping(archetype, node);
        String name = node.getPath().substring(1);
        Query query = session.createQuery("select id from " + mapping.getPersistentClass().getName() + " where archetypeId.shortName = :archetype and " + name + " = :code");
        query.setParameter("archetype", (Object)archetype.getType().getShortName());
        query.setParameter("code", (Object)lookup.getCode());
        query.setMaxResults(1);
        return !query.list().isEmpty();
    }

    private boolean isDetailsNode(NodeDescriptor node) {
        return node.getPath().startsWith("/details/");
    }

    private void replaceCodeSQL(NodeDescriptor node, ArchetypeDescriptor archetype, org.openvpms.component.model.lookup.Lookup source, org.openvpms.component.model.lookup.Lookup target, Session session) {
        Mapping mapping = this.getMapping(archetype, node);
        NativeQuery query = session.createSQLQuery(mapping.getUpdateSQL());
        query.setParameter("archetype", (Object)archetype.getType().getShortName());
        query.setParameter("name", (Object)node.getName());
        query.setParameter("oldCode", (Object)source.getCode());
        query.setParameter("newCode", (Object)target.getCode());
        this.executeUpdate((Query<?>)query, session, mapping.getPersistentClass());
    }

    private void replaceCodeHQL(NodeDescriptor node, ArchetypeDescriptor archetype, org.openvpms.component.model.lookup.Lookup source, org.openvpms.component.model.lookup.Lookup target, Session session) {
        Mapping mapping = this.getMapping(archetype, node);
        String name = node.getPath().substring(1);
        Query query = session.createQuery("update " + mapping.getPersistentClass().getName() + " set " + name + " = :newCode where archetypeId.shortName = :archetype and " + name + " = :oldCode");
        query.setParameter("archetype", (Object)archetype.getType().getShortName());
        query.setParameter("oldCode", (Object)source.getCode());
        query.setParameter("newCode", (Object)target.getCode());
        this.executeUpdate(query, session, mapping.getPersistentClass());
    }

    private boolean isClassificationInUse(org.openvpms.component.model.lookup.Lookup lookup, String sql, Session session) {
        NativeQuery query = session.createSQLQuery(sql);
        query.setParameter("id", (Object)lookup.getId());
        query.setMaxResults(1);
        return !query.list().isEmpty();
    }

    private boolean isLinkTarget(org.openvpms.component.model.lookup.Lookup lookup, Session session) {
        NativeQuery query = session.createSQLQuery("SELECT id FROM lookup_links WHERE target_id = :targetId");
        query.setParameter("targetId", (Object)lookup.getId());
        query.setMaxResults(1);
        return !query.list().isEmpty();
    }

    private void replaceClassifications(org.openvpms.component.model.lookup.Lookup source, org.openvpms.component.model.lookup.Lookup target, String updateSQL, String deleteSQL, Session session, Class<?> ... persistentClasses) {
        NativeQuery query = session.createSQLQuery(updateSQL);
        query.setParameter("oldId", (Object)source.getId());
        query.setParameter("newId", (Object)target.getId());
        this.executeUpdate((Query<?>)query, session, persistentClasses);
        query = session.createSQLQuery(deleteSQL);
        query.setParameter("oldId", (Object)source.getId());
        query.executeUpdate();
    }

    private void executeUpdate(Query<?> query, Session session, final Class<?> ... persistentClasses) {
        int updates = query.executeUpdate();
        if (updates != 0) {
            final SessionFactory factory = session.getSessionFactory();
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                    public void afterCompletion(int status) {
                        if (status == 0) {
                            LookupReplacer.this.clearCaches(persistentClasses, factory);
                        }
                    }
                });
            } else {
                this.clearCaches(persistentClasses, factory);
            }
        }
    }

    private void clearCaches(Class<?>[] persistentClasses, SessionFactory factory) {
        for (Class<?> persistentClass : persistentClasses) {
            factory.getCache().evictEntityData(persistentClass);
        }
    }

    private Mapping getMapping(ArchetypeDescriptor archetype, NodeDescriptor node) {
        Class<?> clazz = archetype.getClazz();
        Mapping mapping = mappings.get(clazz);
        while (mapping == null && !clazz.equals(Object.class)) {
            clazz = clazz.getSuperclass();
            mapping = mappings.get(clazz);
        }
        if (mapping == null) {
            throw new IllegalStateException("Cannot update code node=" + node.getName() + ", archetype=" + archetype.getType() + ". Unsupported class: " + clazz);
        }
        return mapping;
    }

    private static String createUpdateSQL(String table, String details, String id) {
        return "update " + table + " t join " + details + " d on t." + id + " = d." + id + " set d.value = :newCode where t.arch_short_name=:archetype and d.name = :name and d.value = :oldCode";
    }

    private static String createIsUsedSQL(String table, String details, String id) {
        return "select t." + id + " from " + table + " t join " + details + " d on t." + id + " = d." + id + " where t.arch_short_name=:archetype and d.name = :name and d.value = :code";
    }

    private static String createClassificationsSelectSQL(String table) {
        return "select * from " + table + " t where t.lookup_id = :id";
    }

    private static String createClassificationsUpdateSQL(String table, String id) {
        return "update " + table + " c1 left join " + table + " c2 on c1." + id + " = c2." + id + " and c2.lookup_id = :newId set c1.lookup_id = :newId where c1.lookup_id = :oldId and c2.lookup_id is null";
    }

    private static String createClassificationsDeleteSQL(String table) {
        return "delete from " + table + " where lookup_id = :oldId";
    }

    private static void addMapping(Class<?> clazz, String table, String detailsTable, String joinColumn, Class<?> impl) {
        mappings.put(clazz, new Mapping(table, detailsTable, joinColumn, impl));
    }

    static {
        mappings = new HashMap();
        LookupReplacer.addMapping(Act.class, "acts", "act_details", "act_id", ActDOImpl.class);
        LookupReplacer.addMapping(ActRelationship.class, "act_relationships", "act_relationship_details", "act_relationship_id", ActRelationshipDOImpl.class);
        LookupReplacer.addMapping(Contact.class, "contacts", "contact_details", "contact_id", ContactDOImpl.class);
        LookupReplacer.addMapping(Document.class, "documents", "document_details", "document_id", DocumentDOImpl.class);
        LookupReplacer.addMapping(Entity.class, "entities", "entity_details", "entity_id", EntityDOImpl.class);
        LookupReplacer.addMapping(EntityIdentity.class, "entity_identities", "entity_identity_details", "entity_identity_id", EntityIdentityDOImpl.class);
        LookupReplacer.addMapping(EntityRelationship.class, "entity_relationships", "entity_relationship_details", "entity_relationship_id", EntityRelationshipDOImpl.class);
        LookupReplacer.addMapping(EntityLink.class, "entity_links", "entity_link_details", "id", EntityLinkDOImpl.class);
        LookupReplacer.addMapping(Lookup.class, "lookups", "lookup_details", "lookup_id", LookupDOImpl.class);
        LookupReplacer.addMapping(LookupRelationship.class, "lookup_relationships", "lookup_relationship_details", "lookup_relationship_id", LookupRelationshipDOImpl.class);
        LookupReplacer.addMapping(LookupLink.class, "lookup_links", "lookup_link_details", "id", LookupLinkDOImpl.class);
        LookupReplacer.addMapping(Participation.class, "participations", "participation_details", "participation_id", ParticipationDOImpl.class);
        LookupReplacer.addMapping(ProductPrice.class, "product_prices", "product_price_details", "product_price_id", ProductPriceDOImpl.class);
        ENTITY_CLASSIFICATIONS_SELECT = LookupReplacer.createClassificationsSelectSQL(ENTITY_CLASSIFICATIONS);
        ENTITY_CLASSIFICATIONS_UPDATE = LookupReplacer.createClassificationsUpdateSQL(ENTITY_CLASSIFICATIONS, "entity_id");
        ENTITY_CLASSIFICATIONS_DELETE = LookupReplacer.createClassificationsDeleteSQL(ENTITY_CLASSIFICATIONS);
        CONTACT_CLASSIFICATIONS_SELECT = LookupReplacer.createClassificationsSelectSQL(CONTACT_CLASSIFICATIONS);
        CONTACT_CLASSIFICATIONS_UPDATE = LookupReplacer.createClassificationsUpdateSQL(CONTACT_CLASSIFICATIONS, "contact_id");
        CONTACT_CLASSIFICATIONS_DELETE = LookupReplacer.createClassificationsDeleteSQL(CONTACT_CLASSIFICATIONS);
        PRICE_CLASSIFICATIONS_SELECT = LookupReplacer.createClassificationsSelectSQL(PRODUCT_PRICE_CLASSIFICATIONS);
        PRICE_CLASSIFICATIONS_UPDATE = LookupReplacer.createClassificationsUpdateSQL(PRODUCT_PRICE_CLASSIFICATIONS, "product_price_id");
        PRICE_CLASSIFICATIONS_DELETE = LookupReplacer.createClassificationsDeleteSQL(PRODUCT_PRICE_CLASSIFICATIONS);
    }

    private static class Mapping {
        private final String updateSQL;
        private final String isUsedSQL;
        private final Class<?> persistentClass;

        public Mapping(String table, String details, String joinColumn, Class<?> persistentClass) {
            this.updateSQL = LookupReplacer.createUpdateSQL(table, details, joinColumn);
            this.isUsedSQL = LookupReplacer.createIsUsedSQL(table, details, joinColumn);
            this.persistentClass = persistentClass;
        }

        public String getUpdateSQL() {
            return this.updateSQL;
        }

        public String getIsUsedSQL() {
            return this.isUsedSQL;
        }

        public Class<?> getPersistentClass() {
            return this.persistentClass;
        }
    }
}

