/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openvpms.component.business.dao.hibernate.im.common.Assembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.entity.AbstractNodeResultCollector;
import org.openvpms.component.business.dao.im.common.IMObjectDAOException;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.system.common.query.NodeSet;

public class NodeSetResultCollector
extends AbstractNodeResultCollector<NodeSet> {
    private List<NodeSet> result = new ArrayList<NodeSet>();

    public NodeSetResultCollector(IArchetypeDescriptorCache cache, Collection<String> nodes) {
        super(cache, nodes);
    }

    @Override
    public void collect(Object object) {
        if (!(object instanceof IMObjectDO)) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.CannotCollectObject, object.getClass().getName());
        }
        Context context = this.getContext();
        Assembler assembler = context.getAssembler();
        IMObject obj = assembler.assemble((IMObjectDO)object, context);
        NodeSet nodes = new NodeSet(obj.getObjectReference());
        for (NodeDescriptor descriptor : this.getDescriptors(obj)) {
            Object value = this.loadValue(descriptor, obj);
            nodes.set(descriptor.getName(), value);
        }
        this.result.add(nodes);
    }

    @Override
    protected List<NodeSet> getResults() {
        return this.result;
    }
}

