/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.common;

import org.hibernate.Hibernate;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.DeferredAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.DeferredReference;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDOImpl;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectRelationshipDO;
import org.openvpms.component.business.dao.hibernate.im.common.ReferenceUpdater;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;

public abstract class IMObjectRelationshipAssembler<T extends IMObjectRelationship, DO extends IMObjectRelationshipDO>
extends IMObjectAssembler<T, DO> {
    private final Class<? extends IMObjectDO> endType;
    private final Class<? extends IMObjectDOImpl> endTypeImpl;

    protected IMObjectRelationshipAssembler(Class<? extends IMObject> type, Class<T> typeImpl, Class<DO> typeDO, Class<? extends IMObjectDOImpl> typeDOImpl, Class<? extends IMObjectDO> endType, Class<? extends IMObjectDOImpl> endTypeImpl) {
        super(type, typeImpl, typeDO, typeDOImpl);
        this.endType = endType;
        this.endTypeImpl = endTypeImpl;
    }

    @Override
    protected void assembleDO(DO target, T source, DOState state, Context context) {
        super.assembleDO(target, source, state, context);
        this.assembleSource(target, source, state, context);
        this.assembleTarget(target, source, state, context);
    }

    @Override
    protected void assembleObject(T target, DO source, Context context) {
        super.assembleObject(target, source, context);
        this.assembleSourceRef(target, source, context);
        this.assembleTargetRef(target, source, context);
    }

    private void assembleSource(DO result, T source, DOState state, Context context) {
        final IMObjectReference sourceRef = ((IMObjectRelationship)source).getSource();
        if (sourceRef != null) {
            DOState sourceDO = this.get(sourceRef, this.endType, this.endTypeImpl, context);
            if (sourceDO != null) {
                result.setSource(sourceDO.getObject());
                state.addState(sourceDO);
            } else {
                new DeferredAssembler(state, sourceRef, (IMObjectRelationshipDO)result){
                    final /* synthetic */ IMObjectRelationshipDO val$result;
                    {
                        this.val$result = iMObjectRelationshipDO;
                        super(state, reference);
                    }

                    @Override
                    protected void doAssemble(Context context) {
                        Object source = this.load(sourceRef, IMObjectRelationshipAssembler.this.endType, IMObjectRelationshipAssembler.this.endTypeImpl, context);
                        this.val$result.setSource((IMObjectDO)source);
                    }
                };
            }
            if (sourceRef.isNew()) {
                new ReferenceUpdater(state, sourceRef, (IMObjectRelationship)source){
                    final /* synthetic */ IMObjectRelationship val$source;
                    {
                        this.val$source = iMObjectRelationship;
                        super(state, reference);
                    }

                    @Override
                    protected void doUpdate(Reference updated) {
                        this.val$source.setSource(updated);
                    }
                };
            }
        } else {
            result.setSource(null);
        }
    }

    private void assembleTarget(DO result, T source, DOState state, Context context) {
        final IMObjectReference targetRef = ((IMObjectRelationship)source).getTarget();
        if (targetRef != null) {
            DOState targetDO = this.get(targetRef, this.endType, this.endTypeImpl, context);
            if (targetDO != null) {
                result.setTarget(targetDO.getObject());
                state.addState(targetDO);
            } else {
                new DeferredAssembler(state, targetRef, (IMObjectRelationshipDO)result){
                    final /* synthetic */ IMObjectRelationshipDO val$result;
                    {
                        this.val$result = iMObjectRelationshipDO;
                        super(state, reference);
                    }

                    @Override
                    public void doAssemble(Context context) {
                        Object target = this.load(targetRef, IMObjectRelationshipAssembler.this.endType, IMObjectRelationshipAssembler.this.endTypeImpl, context);
                        this.val$result.setTarget((IMObjectDO)target);
                    }
                };
            }
            if (targetRef.isNew()) {
                new ReferenceUpdater(state, targetRef, (IMObjectRelationship)source){
                    final /* synthetic */ IMObjectRelationship val$source;
                    {
                        this.val$source = iMObjectRelationship;
                        super(state, reference);
                    }

                    @Override
                    protected void doUpdate(Reference updated) {
                        this.val$source.setTarget(updated);
                    }
                };
            }
        } else {
            result.setTarget(null);
        }
    }

    private void assembleSourceRef(T result, DO source, Context context) {
        IMObjectDO relSource = source.getSource();
        if (relSource != null) {
            if (Hibernate.isInitialized((Object)relSource)) {
                ((IMObjectRelationship)result).setSource(context.getReference(relSource, this.endTypeImpl));
            } else {
                context.addDeferredReference(new DeferredReference(relSource, this.endTypeImpl, (IMObjectRelationship)result){
                    final /* synthetic */ IMObjectRelationship val$result;
                    {
                        this.val$result = iMObjectRelationship;
                        super(object, type);
                    }

                    @Override
                    public void update(IMObjectReference reference) {
                        this.val$result.setSource(reference);
                    }
                });
            }
        } else {
            ((IMObjectRelationship)result).setSource((IMObjectReference)null);
        }
    }

    private void assembleTargetRef(T result, DO source, Context context) {
        IMObjectDO relTarget = source.getTarget();
        if (relTarget != null) {
            if (Hibernate.isInitialized((Object)relTarget)) {
                ((IMObjectRelationship)result).setTarget(context.getReference(relTarget, this.endTypeImpl));
            } else {
                context.addDeferredReference(new DeferredReference(relTarget, this.endTypeImpl, (IMObjectRelationship)result){
                    final /* synthetic */ IMObjectRelationship val$result;
                    {
                        this.val$result = iMObjectRelationship;
                        super(object, type);
                    }

                    @Override
                    public void update(IMObjectReference reference) {
                        this.val$result.setTarget(reference);
                    }
                });
            }
        } else {
            ((IMObjectRelationship)result).setTarget((IMObjectReference)null);
        }
    }
}

