/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.act;

import java.sql.Timestamp;
import org.openvpms.component.business.dao.hibernate.im.act.ActDO;
import org.openvpms.component.business.dao.hibernate.im.act.ActIdentityDO;
import org.openvpms.component.business.dao.hibernate.im.act.ActRelationshipDO;
import org.openvpms.component.business.dao.hibernate.im.act.ParticipationDO;
import org.openvpms.component.business.dao.hibernate.im.common.AuditableIMObjectAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDOImpl;
import org.openvpms.component.business.dao.hibernate.im.common.SetAssembler;
import org.openvpms.component.business.domain.im.act.Act;
import org.openvpms.component.business.domain.im.act.ActIdentity;
import org.openvpms.component.business.domain.im.act.ActRelationship;
import org.openvpms.component.business.domain.im.common.Participation;
import org.openvpms.component.model.object.IMObject;

public abstract class AbstractActAssembler<T extends Act, DO extends ActDO>
extends AuditableIMObjectAssembler<T, DO> {
    private static final SetAssembler<ActIdentity, ActIdentityDO> IDENTITIES = SetAssembler.create(ActIdentity.class, ActIdentityDO.class);
    private static final SetAssembler<Participation, ParticipationDO> PARTICIPATIONS = SetAssembler.create(Participation.class, ParticipationDO.class);
    private static final SetAssembler<ActRelationship, ActRelationshipDO> RELATIONSHIPS = SetAssembler.create(ActRelationship.class, ActRelationshipDO.class);

    protected AbstractActAssembler(Class<? extends IMObject> type, Class<T> typeImpl, Class<DO> typeDO, Class<? extends IMObjectDOImpl> implDO) {
        super(type, typeImpl, typeDO, implDO);
    }

    @Override
    protected void assembleDO(DO target, T source, DOState state, Context context) {
        super.assembleDO(target, source, state, context);
        Timestamp startTime = AbstractActAssembler.getTimestamp(((Act)source).getActivityStartTime());
        Timestamp endTime = AbstractActAssembler.getTimestamp(((Act)source).getActivityEndTime());
        target.setTitle(((Act)source).getTitle());
        target.setActivityStartTime(startTime);
        target.setActivityEndTime(endTime);
        target.setReason(((Act)source).getReason());
        target.setStatus(((Act)source).getStatus());
        target.setStatus2(((Act)source).getStatus2());
        IDENTITIES.assembleDO(target.getIdentities(), ((Act)source).getIdentities(), state, context);
        RELATIONSHIPS.assembleDO(target.getSourceActRelationships(), ((Act)source).getSourceActRelationships(), state, context);
        RELATIONSHIPS.assembleDO(target.getTargetActRelationships(), ((Act)source).getTargetActRelationships(), state, context);
        PARTICIPATIONS.assembleDO(target.getParticipations(), ((Act)source).getParticipations(), state, context);
        for (ParticipationDO participation : target.getParticipations()) {
            participation.setActivityStartTime(startTime);
            participation.setActivityEndTime(endTime);
        }
    }

    @Override
    protected void assembleObject(T target, DO source, Context context) {
        super.assembleObject(target, source, context);
        ((Act)target).setTitle(source.getTitle());
        ((Act)target).setActivityStartTime(source.getActivityStartTime());
        ((Act)target).setActivityEndTime(source.getActivityEndTime());
        ((Act)target).setReason(source.getReason());
        ((Act)target).setStatus(source.getStatus());
        ((Act)target).setStatus2(source.getStatus2());
        IDENTITIES.assembleObject(((Act)target).getIdentities(), source.getIdentities(), context);
        RELATIONSHIPS.assembleObject(((Act)target).getSourceActRelationships(), source.getSourceActRelationships(), context);
        RELATIONSHIPS.assembleObject(((Act)target).getTargetActRelationships(), source.getTargetActRelationships(), context);
        PARTICIPATIONS.assembleObject(((Act)target).getParticipations(), source.getParticipations(), context);
    }
}

