/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.metadata;

import org.drools.DroolsException;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.spring.metadata.ArgumentMetadata;
import org.drools.spring.metadata.BeanObjectType;
import org.drools.spring.pojorule.Argument;
import org.drools.spring.pojorule.FactArgument;

public final class FactArgumentMetadata
implements ArgumentMetadata {
    static final String BASE_DEFAULT_IDENTIFIER = "Fact$";
    private String identifier;
    private final Class parameterClass;

    public FactArgumentMetadata(String identifier, Class parameterClass) {
        if (parameterClass == null) {
            throw new IllegalArgumentException("parameterClass must not be null");
        }
        this.identifier = identifier == null || identifier.trim().length() == 0 ? FactArgumentMetadata.getDefaultIdentifier(parameterClass) : identifier;
        this.parameterClass = parameterClass;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Class getParameterClass() {
        return this.parameterClass;
    }

    public Argument createArgument(Rule rule) throws DroolsException {
        Declaration declaration = rule.getParameterDeclaration(this.identifier);
        if (declaration == null) {
            BeanObjectType objectType = new BeanObjectType(this.parameterClass);
            declaration = rule.addParameterDeclaration(this.identifier, objectType);
        }
        return new FactArgument(declaration);
    }

    static String getDefaultIdentifier(Class parameterClass) {
        return BASE_DEFAULT_IDENTIFIER + parameterClass.getName();
    }
}

