/*
 * Decompiled with CFR 0.152.
 */
package org.drools.smf;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.spi.ImportEntry;
import org.drools.spi.Importer;

public class DefaultImporter
implements Importer {
    private Set importEntrySet = Collections.EMPTY_SET;
    private Set importSet = Collections.EMPTY_SET;
    private Map cachedImports = Collections.EMPTY_MAP;

    public Set getImportEntries() {
        return this.importEntrySet;
    }

    public Set getImports() {
        if (!this.importEntrySet.isEmpty()) {
            if (this.importSet == Collections.EMPTY_SET) {
                this.importSet = new HashSet();
            }
            Iterator i = this.importEntrySet.iterator();
            while (i.hasNext()) {
                this.importSet.add(((ImportEntry)i.next()).getImportEntry());
            }
        }
        return this.importSet;
    }

    public void addImport(ImportEntry importEntry) {
        if (this.importEntrySet == Collections.EMPTY_SET) {
            this.importEntrySet = new HashSet();
        }
        this.importEntrySet.add(importEntry);
    }

    public Class lookupFromCache(String className) {
        if (this.cachedImports == Collections.EMPTY_MAP) {
            return null;
        }
        return (Class)this.cachedImports.get(className);
    }

    public Class importClass(ClassLoader cl, String className) throws ClassNotFoundException {
        Class clazz = null;
        try {
            clazz = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        if (clazz == null) {
            clazz = this.lookupFromCache(className);
        }
        if (clazz == null) {
            HashSet<Class> validClazzCandidates = new HashSet<Class>();
            Iterator it = this.importEntrySet.iterator();
            while (it.hasNext()) {
                clazz = this.importClass(cl, ((ImportEntry)it.next()).getImportEntry(), className.trim());
                if (clazz == null) continue;
                validClazzCandidates.add(clazz);
            }
            if (validClazzCandidates.size() > 1) {
                StringBuffer sb = new StringBuffer();
                Iterator clazzCandIter = validClazzCandidates.iterator();
                while (clazzCandIter.hasNext()) {
                    if (0 != sb.length()) {
                        sb.append(", ");
                    }
                    sb.append(((Class)clazzCandIter.next()).getName());
                }
                throw new Error("Unable to find unambiguously defined class '" + className + "', candidates are: [" + sb.toString() + "]");
            }
            clazz = validClazzCandidates.size() == 1 ? (Class)validClazzCandidates.toArray()[0] : null;
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Unable to find class '" + className + "'");
        }
        return clazz;
    }

    private Class importClass(ClassLoader cl, String importText, String className) {
        String qualifiedClass = null;
        Class<?> clazz = null;
        String convertedImportText = importText.startsWith("from ") ? this.convertFromPythonImport(importText) : importText;
        if (convertedImportText.endsWith("*")) {
            qualifiedClass = convertedImportText.substring(0, convertedImportText.indexOf(42)) + className;
        } else if (convertedImportText.endsWith("." + className)) {
            qualifiedClass = convertedImportText;
        } else if (convertedImportText.equals(className)) {
            qualifiedClass = convertedImportText;
        }
        if (qualifiedClass != null) {
            try {
                clazz = cl.loadClass(qualifiedClass);
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
        }
        if (clazz != null) {
            if (this.cachedImports == Collections.EMPTY_MAP) {
                this.cachedImports = new HashMap();
            }
            this.cachedImports.put(className, clazz);
        }
        return clazz;
    }

    private String convertFromPythonImport(String packageText) {
        String fromString = "from ";
        String importString = "import ";
        int fromIndex = packageText.indexOf(fromString);
        int importIndex = packageText.indexOf(importString);
        return packageText.substring(fromIndex + fromString.length(), importIndex).trim() + "." + packageText.substring(importIndex + importString.length()).trim();
    }

    public boolean isEmpty() {
        return this.importEntrySet.isEmpty();
    }
}

