/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import org.codehaus.janino.ByteArrayClassLoader;
import org.codehaus.janino.Scanner;
import org.drools.rule.RuleSet;
import org.drools.semantics.java.CompilationException;
import org.drools.semantics.java.ImporterClassBodyEvaluator;
import org.drools.semantics.java.JavaCompiler;
import org.drools.spi.Functions;
import org.drools.spi.Importer;
import org.drools.spi.RuleBaseContext;

public class JavaFunctions
implements Functions {
    private String text;
    private transient Class functionsClass;
    private RuleSet ruleSet;
    private String className;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public JavaFunctions(RuleSet ruleSet, int id, String text) throws CompilationException, IOException, ClassNotFoundException {
        this.text = text;
        this.ruleSet = ruleSet;
        this.className = "Function_" + id;
        this.compile();
    }

    private void compile() throws IOException, CompilationException, ClassNotFoundException {
        RuleBaseContext ruleBaseContext = this.ruleSet.getRuleBaseContext();
        ClassLoader classLoader = (ClassLoader)ruleBaseContext.get("java-classLoader");
        if (classLoader == null) {
            ClassLoader cl = (ClassLoader)ruleBaseContext.get("smf-classLoader");
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
                ruleBaseContext.put("smf-classLoader", cl);
            }
            if (cl == null) {
                cl = JavaCompiler.class.getClassLoader();
                ruleBaseContext.put("smf-classLoader", cl);
            }
            classLoader = new ByteArrayClassLoader(new HashMap(), cl);
        }
        HashSet imports = new HashSet();
        Importer importer = this.ruleSet.getImporter();
        try {
            ImporterClassBodyEvaluator classBody = new ImporterClassBodyEvaluator(importer, this.className, new Scanner(null, (Reader)new StringReader(this.text)), classLoader);
            this.functionsClass = classBody.evaluate();
        }
        catch (Scanner.LocatedException e) {
            throw new CompilationException(this.ruleSet, null, this.text, e.getLocation() != null ? (int)e.getLocation().getLineNumber() : -1, e.getLocation() != null ? (int)e.getLocation().getColumnNumber() : -1, e.getMessage());
        }
        ruleBaseContext.put("java-classLoader", this.functionsClass.getClassLoader());
    }

    public String getText() {
        return this.text;
    }

    public Class getFunctionsClass() throws CompilationException, IOException, ClassNotFoundException {
        if (this.functionsClass == null) {
            this.compile();
        }
        return this.functionsClass;
    }

    public String getSemantic() {
        return "java";
    }
}

