/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.InputStream;
import java.util.HashMap;
import org.drools.decisiontable.model.Ruleset;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.xls.ExcelParser;

public class SpreadsheetDRLConverter {
    public String convertToDRL(InputStream xlsStream) {
        RuleSheetListener listener = this.getRuleSheetListener(xlsStream);
        Ruleset ruleset = listener.getRuleSet();
        return ruleset.toXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertToDRL(String classPathResource) {
        InputStream stream = this.getClass().getResourceAsStream(classPathResource);
        try {
            String drl;
            String string = drl = this.convertToDRL(stream);
            return string;
        }
        finally {
            this.closeStream(stream);
        }
    }

    public String convertToDRL(InputStream stream, String worksheetName) {
        RuleSheetListener listener = this.getRuleSheetListener(stream, worksheetName);
        Ruleset ruleset = listener.getRuleSet();
        return ruleset.toXML();
    }

    private RuleSheetListener getRuleSheetListener(InputStream stream) {
        RuleSheetListener listener = new RuleSheetListener();
        ExcelParser parser = new ExcelParser(listener);
        parser.parseFile(stream);
        return listener;
    }

    private RuleSheetListener getRuleSheetListener(InputStream stream, String worksheetName) {
        RuleSheetListener listener = new RuleSheetListener();
        HashMap<String, RuleSheetListener> listeners = new HashMap<String, RuleSheetListener>();
        listeners.put(worksheetName, listener);
        ExcelParser parser = new ExcelParser(listeners);
        parser.parseFile(stream);
        return listener;
    }

    private void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

