/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.resources.ResourcesException;
import org.apache.commons.resources.impl.CollectionResourcesBase;

public class JDBCResources
extends CollectionResourcesBase {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$resources$impl$JDBCResources == null ? (class$org$apache$commons$resources$impl$JDBCResources = JDBCResources.class$("org.apache.commons.resources.impl.JDBCResources")) : class$org$apache$commons$resources$impl$JDBCResources));
    Connection con = null;
    static /* synthetic */ Class class$org$apache$commons$resources$impl$JDBCResources;

    public JDBCResources(String name, String base) {
        super(name, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Map getLocaleMap(String baseUrl, Locale locale) {
        Properties props;
        block20: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading database configuration'" + locale + "' resources from base '" + baseUrl + "'"));
            }
            props = new Properties();
            String name = baseUrl + ".properties";
            InputStream stream = null;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Absolute URL is '" + name + "'"));
            }
            URL url = new URL(name);
            stream = url.openStream();
            if (log.isTraceEnabled()) {
                log.trace((Object)"Parsing input resource");
            }
            props.load(stream);
            Object var8_9 = null;
            if (stream == null) break block20;
            try {
                stream.close();
            }
            catch (IOException e2) {
                log.error((Object)"Error closing stream.", (Throwable)e2);
            }
            stream = null;
            {
                break block20;
                catch (FileNotFoundException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No resources for locale '" + locale + "' from base '" + baseUrl + "'"));
                    }
                    props.clear();
                    Object var8_10 = null;
                    if (stream == null) break block20;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        log.error((Object)"Error closing stream.", (Throwable)e2);
                    }
                    stream = null;
                    break block20;
                }
                catch (IOException e) {
                    log.warn((Object)("IOException loading locale '" + locale + "' from base '" + baseUrl + "'"), (Throwable)e);
                    props.clear();
                    Object var8_11 = null;
                    if (stream == null) break block20;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        log.error((Object)"Error closing stream.", (Throwable)e2);
                    }
                    stream = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        log.error((Object)"Error closing stream.", (Throwable)e2);
                    }
                    stream = null;
                }
                throw throwable;
            }
        }
        Properties properties = new Properties();
        try {
            properties = this.loadData(locale, props);
        }
        catch (InstantiationException e) {
            log.warn((Object)("InstantiationException: locale= '" + locale + "' base= '" + baseUrl + "'"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("IllegalAccessException: locale= '" + locale + "' base= '" + baseUrl + "'"), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Specified Driver not found, make sure it is on the classpath: locale= '" + locale + "' base= '" + baseUrl + "'"), (Throwable)e);
        }
        catch (SQLException e) {
            log.warn((Object)("SQLException: locale= '" + locale + "' base= '" + baseUrl + "'"), (Throwable)e);
        }
        return properties;
    }

    private Properties loadData(Locale locale, Properties connectionProps) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        String driver = connectionProps.getProperty("jdbc.connect.driver");
        String url = connectionProps.getProperty("jdbc.connect.url");
        String user = connectionProps.getProperty("jdbc.connect.login");
        String pass = connectionProps.getProperty("jdbc.connect.password");
        String table = connectionProps.getProperty("jdbc.sql.table");
        String localeColumn = connectionProps.getProperty("jdbc.sql.locale.column");
        String keyColumn = connectionProps.getProperty("jdbc.sql.key.column");
        String valColumn = connectionProps.getProperty("jdbc.sql.val.column");
        Properties pairs = new Properties();
        Class.forName(driver).newInstance();
        this.con = DriverManager.getConnection(url, user, pass);
        String query = "SELECT " + keyColumn + ", " + valColumn + " FROM " + table + " where " + localeColumn + "= '" + locale + "'";
        PreparedStatement stmt = this.con.prepareStatement(query);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            pairs.put(rs.getString(keyColumn), rs.getString(valColumn));
        }
        return pairs;
    }

    public void init() throws ResourcesException {
        super.init();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

