/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.oscache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springmodules.cache.provider.AbstractCacheProfileEditor;
import org.springmodules.cache.provider.AbstractCacheProviderFacadeImpl;
import org.springmodules.cache.provider.CacheProfile;
import org.springmodules.cache.provider.CacheProfileValidator;
import org.springmodules.cache.provider.oscache.OsCacheProfile;
import org.springmodules.cache.provider.oscache.OsCacheProfileEditor;
import org.springmodules.cache.provider.oscache.OsCacheProfileValidator;

public final class OsCacheFacade
extends AbstractCacheProviderFacadeImpl {
    private static Log logger = LogFactory.getLog((Class)(class$org$springmodules$cache$provider$oscache$OsCacheFacade == null ? (class$org$springmodules$cache$provider$oscache$OsCacheFacade = OsCacheFacade.class$("org.springmodules.cache.provider.oscache.OsCacheFacade")) : class$org$springmodules$cache$provider$oscache$OsCacheFacade));
    private GeneralCacheAdministrator cacheManager;
    static /* synthetic */ Class class$org$springmodules$cache$provider$oscache$OsCacheFacade;

    protected AbstractCacheProfileEditor getCacheProfileEditor() {
        return new OsCacheProfileEditor();
    }

    protected CacheProfileValidator getCacheProfileValidator() {
        return new OsCacheProfileValidator();
    }

    protected String getEntryKey(Serializable cacheKey) {
        return cacheKey.toString();
    }

    protected void onCancelCacheUpdate(Serializable cacheKey) {
        String key = this.getEntryKey(cacheKey);
        this.cacheManager.cancelUpdate(key);
    }

    protected void onFlushCache(CacheProfile cacheProfile) {
        OsCacheProfile profile = (OsCacheProfile)cacheProfile;
        String[] groups = profile.getGroups();
        if (groups != null) {
            int groupCount = groups.length;
            for (int i = 0; i < groupCount; ++i) {
                String group = groups[i];
                this.cacheManager.flushGroup(group);
            }
        }
    }

    protected Object onGetFromCache(Serializable cacheKey, CacheProfile cacheProfile) {
        Object cachedObject;
        block2: {
            OsCacheProfile profile = (OsCacheProfile)cacheProfile;
            Integer refreshPeriod = profile.getRefreshPeriod();
            String cronExpression = profile.getCronExpression();
            String key = this.getEntryKey(cacheKey);
            cachedObject = null;
            try {
                cachedObject = null == refreshPeriod ? this.cacheManager.getFromCache(key) : (null == cronExpression ? this.cacheManager.getFromCache(key, refreshPeriod.intValue()) : this.cacheManager.getFromCache(key, refreshPeriod.intValue(), cronExpression));
            }
            catch (NeedsRefreshException needsRefreshException) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)"Method 'getFromCache(..)'. Object not found in the OSCache cache");
            }
        }
        return cachedObject;
    }

    protected void onPutInCache(Serializable cacheKey, CacheProfile cacheProfile, Object objectToCache) {
        OsCacheProfile profile = (OsCacheProfile)cacheProfile;
        String key = this.getEntryKey(cacheKey);
        String[] groups = profile.getGroups();
        if (groups == null || groups.length == 0) {
            this.cacheManager.putInCache(key, objectToCache);
        } else {
            this.cacheManager.putInCache(key, objectToCache, groups);
        }
    }

    public void removeFromCache(Serializable cacheKey, String cacheProfileId) {
        this.cacheManager.flushEntry(this.getEntryKey(cacheKey));
    }

    public void setCacheManager(GeneralCacheAdministrator cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected void validateCacheManager() {
        if (null == this.cacheManager) {
            throw new IllegalStateException("The Cache Manager should not be null");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

