/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.ehcache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springmodules.cache.CacheWrapperException;
import org.springmodules.cache.EntryRetrievalException;
import org.springmodules.cache.provider.AbstractCacheProfileEditor;
import org.springmodules.cache.provider.AbstractCacheProviderFacadeImpl;
import org.springmodules.cache.provider.CacheProfile;
import org.springmodules.cache.provider.CacheProfileValidator;
import org.springmodules.cache.provider.ehcache.EhCacheProfile;
import org.springmodules.cache.provider.ehcache.EhCacheProfileEditor;
import org.springmodules.cache.provider.ehcache.EhCacheProfileValidator;

public final class EhCacheFacade
extends AbstractCacheProviderFacadeImpl {
    private static Log logger = LogFactory.getLog((Class)(class$org$springmodules$cache$provider$ehcache$EhCacheFacade == null ? (class$org$springmodules$cache$provider$ehcache$EhCacheFacade = EhCacheFacade.class$("org.springmodules.cache.provider.ehcache.EhCacheFacade")) : class$org$springmodules$cache$provider$ehcache$EhCacheFacade));
    private CacheManager cacheManager;
    static /* synthetic */ Class class$org$springmodules$cache$provider$ehcache$EhCacheFacade;

    protected AbstractCacheProfileEditor getCacheProfileEditor() {
        return new EhCacheProfileEditor();
    }

    protected CacheProfileValidator getCacheProfileValidator() {
        return new EhCacheProfileValidator();
    }

    protected void onFlushCache(CacheProfile cacheProfile) {
        EhCacheProfile profile = (EhCacheProfile)cacheProfile;
        String cacheName = profile.getCacheName();
        if (StringUtils.isNotEmpty((String)cacheName)) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                if (logger.isInfoEnabled()) {
                    String logMessage = "Method 'onFlushCache(CacheProfile)'. Could not find EHCache cache: " + cacheName;
                    logger.info((Object)logMessage);
                }
            } else {
                try {
                    cache.removeAll();
                }
                catch (Exception exception) {
                    StringBuffer messageBuffer = new StringBuffer(64);
                    messageBuffer.append("Exception thrown when flushing cache. Variable 'cacheProfile': ");
                    messageBuffer.append(cacheProfile);
                    String errorMessage = messageBuffer.toString();
                    logger.error((Object)errorMessage, (Throwable)exception);
                    throw new CacheWrapperException(errorMessage, exception);
                }
            }
        }
    }

    protected Object onGetFromCache(Serializable cacheKey, CacheProfile cacheProfile) throws EntryRetrievalException {
        Serializable cachedObject = null;
        EhCacheProfile profile = (EhCacheProfile)cacheProfile;
        String cacheName = profile.getCacheName();
        if (StringUtils.isNotEmpty((String)cacheName)) {
            if (!this.cacheManager.cacheExists(cacheName)) {
                String logMessage = "Method 'onGetFromCache(CacheKey, CacheProfile)'. Could not find EHCache cache: " + cacheName;
                logger.info((Object)logMessage);
                throw new EntryRetrievalException("Could not find EHCache cache: " + cacheName);
            }
            Cache cache = this.cacheManager.getCache(cacheName);
            Element cacheElement = null;
            try {
                cacheElement = cache.get(cacheKey);
            }
            catch (Exception exception) {
                StringBuffer messageBuffer = new StringBuffer(64);
                messageBuffer.append("Exception thrown when retrieving an entry from the cache. ");
                messageBuffer.append("Variable 'cacheKey': ");
                messageBuffer.append(cacheKey);
                messageBuffer.append(". Variable 'cacheProfile': ");
                messageBuffer.append(cacheProfile);
                String errorMessage = messageBuffer.toString();
                logger.error((Object)errorMessage, (Throwable)exception);
                throw new CacheWrapperException(errorMessage, exception);
            }
            if (null != cacheElement) {
                cachedObject = cacheElement.getValue();
            }
        }
        return cachedObject;
    }

    protected void onPutInCache(Serializable cacheKey, CacheProfile cacheProfile, Object objectToCache) {
        EhCacheProfile profile = (EhCacheProfile)cacheProfile;
        String cacheName = profile.getCacheName();
        if (StringUtils.isNotEmpty((String)cacheName)) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                if (logger.isInfoEnabled()) {
                    String logMessage = "Method 'onPutInCache(CacheKey, CacheProfile, Object)'. Could not find EHCache cache: " + cacheName;
                    logger.info((Object)logMessage);
                }
            } else {
                Element newCacheElement = new Element(cacheKey, (Serializable)objectToCache);
                cache.put(newCacheElement);
            }
        }
    }

    public void removeFromCache(Serializable cacheKey, String cacheProfileId) {
        CacheProfile cacheProfile = super.getCacheProfile(cacheProfileId);
        EhCacheProfile profile = (EhCacheProfile)cacheProfile;
        String cacheName = profile.getCacheName();
        if (StringUtils.isNotEmpty((String)cacheName)) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                if (logger.isInfoEnabled()) {
                    String logMessage = "Method 'removeFromCache(CacheKey, String)'. Could not find EHCache cache: " + cacheName;
                    logger.info((Object)logMessage);
                }
            } else {
                cache.remove(cacheKey);
            }
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected void validateCacheManager() {
        int cacheManagerStatus;
        if (null == this.cacheManager) {
            throw new IllegalStateException("The Cache Manager should not be null");
        }
        if (!super.isFailQuietlyEnabled() && (cacheManagerStatus = this.cacheManager.getStatus()) != 2) {
            throw new IllegalStateException("Cache Manager is not alive");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

