/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.key;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springmodules.cache.key.CacheKey;
import org.springmodules.cache.key.CacheKeyGenerator;
import org.springmodules.cache.key.HashCodeCacheKey;
import org.springmodules.cache.key.HashCodeCalculator;

public class HashCodeCacheKeyGenerator
implements CacheKeyGenerator {
    private boolean generateArgumentHashCode;

    public HashCodeCacheKeyGenerator() {
    }

    public HashCodeCacheKeyGenerator(boolean generateArgumentHashCode) {
        this();
        this.setGenerateArgumentHashCode(generateArgumentHashCode);
    }

    public final CacheKey generateKey(MethodInvocation methodInvocation) {
        HashCodeCalculator hashCodeCalculator = new HashCodeCalculator();
        Method method = methodInvocation.getMethod();
        int methodHashCode = System.identityHashCode(method);
        hashCodeCalculator.append(methodHashCode);
        Object[] methodArguments = methodInvocation.getArguments();
        if (methodArguments != null) {
            int methodArgumentCount = methodArguments.length;
            for (int i = 0; i < methodArgumentCount; ++i) {
                int methodArgumentHashCode = this.getMethodArgumentHashCode(methodArguments[i]);
                hashCodeCalculator.append(methodArgumentHashCode);
            }
        }
        long checkSum = hashCodeCalculator.getCheckSum();
        int hashCode = hashCodeCalculator.getHashCode();
        HashCodeCacheKey cacheKey = new HashCodeCacheKey(checkSum, hashCode);
        return cacheKey;
    }

    protected final int getMethodArgumentHashCode(Object methodArgument) {
        int methodArgumentHashCode = 0;
        if (methodArgument != null) {
            methodArgumentHashCode = this.generateArgumentHashCode ? HashCodeBuilder.reflectionHashCode((Object)methodArgument) : methodArgument.hashCode();
        }
        return methodArgumentHashCode;
    }

    public final void setGenerateArgumentHashCode(boolean generateArgumentHashCode) {
        this.generateArgumentHashCode = generateArgumentHashCode;
    }
}

