/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.key;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.springmodules.cache.key.CacheKey;

public final class HashCodeCacheKey
implements CacheKey {
    private static final long serialVersionUID = 3904677167731454262L;
    private long checkSum;
    private int hashCode;

    public HashCodeCacheKey() {
    }

    public HashCodeCacheKey(long checkSum, int hashCode) {
        this();
        this.checkSum = checkSum;
        this.hashCode = hashCode;
    }

    public boolean equals(Object obj) {
        boolean equals = true;
        if (null == obj || !(obj instanceof HashCodeCacheKey)) {
            equals = false;
        } else if (this != obj) {
            HashCodeCacheKey cacheKey = (HashCodeCacheKey)obj;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append(this.getCheckSum(), cacheKey.getCheckSum());
            equalsBuilder.append(this.getHashCode(), cacheKey.getHashCode());
            equals = equalsBuilder.isEquals();
        }
        return equals;
    }

    public long getCheckSum() {
        return this.checkSum;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public void setCheckSum(long checkSum) {
        this.checkSum = checkSum;
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public String toString() {
        return this.getHashCode() + "|" + this.getCheckSum();
    }
}

