/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor;

import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springmodules.cache.CacheAttribute;
import org.springmodules.cache.util.TextMatcher;

public abstract class AbstractNameMatchCacheAttributeSource {
    private static Log logger = LogFactory.getLog((Class)(class$org$springmodules$cache$interceptor$AbstractNameMatchCacheAttributeSource == null ? (class$org$springmodules$cache$interceptor$AbstractNameMatchCacheAttributeSource = AbstractNameMatchCacheAttributeSource.class$("org.springmodules.cache.interceptor.AbstractNameMatchCacheAttributeSource")) : class$org$springmodules$cache$interceptor$AbstractNameMatchCacheAttributeSource));
    private Map attributeMap = new HashMap();
    static /* synthetic */ Class class$org$springmodules$cache$interceptor$AbstractNameMatchCacheAttributeSource;

    protected final void addAttribute(String methodName, CacheAttribute cacheAttribute) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method 'addMethod(String, CacheAttribute)'. Adding method [" + methodName + "] with attribute [" + cacheAttribute + "]"));
        }
        this.attributeMap.put(methodName, cacheAttribute);
    }

    protected final Map getAttributeMap() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    protected abstract PropertyEditor getCacheAttributeEditor();

    protected boolean isMatch(String methodName, String mappedName) {
        return TextMatcher.isMatch(methodName, mappedName);
    }

    public final void setProperties(Properties cacheAttributes) {
        PropertyEditor propertyEditor = this.getCacheAttributeEditor();
        Iterator<Object> keySetIterator = cacheAttributes.keySet().iterator();
        while (keySetIterator.hasNext()) {
            String methodName = (String)keySetIterator.next();
            String cacheAttributeProperties = cacheAttributes.getProperty(methodName);
            propertyEditor.setAsText(cacheAttributeProperties);
            CacheAttribute cacheAttribute = (CacheAttribute)propertyEditor.getValue();
            if (cacheAttribute == null) continue;
            this.addAttribute(methodName, cacheAttribute);
        }
    }

    protected final CacheAttribute getCacheAttribute(Method method) {
        String methodName = method.getName();
        CacheAttribute cacheAttribute = (CacheAttribute)this.attributeMap.get(methodName);
        if (cacheAttribute == null) {
            String bestNameMatch = null;
            Iterator keySetIterator = this.attributeMap.keySet().iterator();
            while (keySetIterator.hasNext()) {
                String mappedMethodName = (String)keySetIterator.next();
                if (!this.isMatch(methodName, mappedMethodName) || bestNameMatch != null && bestNameMatch.length() > mappedMethodName.length()) continue;
                cacheAttribute = (CacheAttribute)this.attributeMap.get(mappedMethodName);
                bestNameMatch = mappedMethodName;
            }
        }
        return cacheAttribute;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

