/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.pentaho;

import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.etl.load.ETLLogDAO;
import org.openvpms.etl.load.ETLRow;
import org.openvpms.etl.load.ErrorListener;
import org.openvpms.etl.load.Loader;
import org.openvpms.etl.load.Mapping;
import org.openvpms.etl.load.Mappings;
import org.openvpms.etl.pentaho.Messages;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class LoaderAdapter {
    private final Mappings mappings;
    private final Loader loader;

    public LoaderAdapter(String name, Mappings mappings, ETLLogDAO dao, IArchetypeService service, LookupService lookups) {
        this.mappings = mappings;
        this.loader = new Loader(name, mappings, dao, service, lookups);
    }

    public List<IMObject> load(RowMetaInterface metaData, Object[] row) throws KettleException {
        int idIndex = metaData.indexOfValue(this.mappings.getIdColumn());
        if (idIndex == -1) {
            String msg = Messages.get("LoaderAdapter.MissingColumn", this.mappings.getIdColumn());
            throw new KettleException(msg);
        }
        ValueMetaInterface valueMeta = metaData.getValueMeta(idIndex);
        String id = this.getLegacyId(valueMeta, row[idIndex]);
        if (StringUtils.isEmpty((CharSequence)id)) {
            String msg = Messages.get("LoaderAdapter.NullIdColumn", this.mappings.getIdColumn());
            throw new KettleException(msg);
        }
        ETLRow mapRow = new ETLRow(id);
        for (Mapping mapping : this.mappings.getMapping()) {
            int index = metaData.indexOfValue(mapping.getSource());
            if (index != -1) continue;
            String msg = Messages.get("LoaderAdapter.MissingColumn", mapping.getSource());
            throw new KettleException(msg);
        }
        for (int i = 0; i < metaData.size(); ++i) {
            valueMeta = metaData.getValueMeta(i);
            Object value = this.getValue(valueMeta, row[i]);
            mapRow.add(valueMeta.getName(), value);
        }
        return this.loader.load(mapRow);
    }

    public void setErrorListener(ErrorListener listener) {
        this.loader.setErrorListener(listener);
    }

    public void close() {
        this.loader.close();
    }

    private Object getValue(ValueMetaInterface valueMeta, Object value) throws KettleException {
        Object result;
        int type = valueMeta.getType();
        if (type == 3) {
            result = valueMeta.getDate(value);
        } else if (type == 1) {
            result = valueMeta.getPrecision() == 0 ? valueMeta.getBigNumber(value).toBigIntegerExact() : valueMeta.getBigNumber(value);
        } else if (type == 5) {
            result = valueMeta.getInteger(value);
        } else if (type == 6) {
            result = valueMeta.getBigNumber(value);
        } else {
            String str = valueMeta.getString(value);
            result = StringUtils.trimToNull((String)str);
        }
        return result;
    }

    private String getLegacyId(ValueMetaInterface valueMeta, Object id) throws KettleException {
        String result = null;
        if (!valueMeta.isNull(id)) {
            if (valueMeta.getType() == 3) {
                Timestamp datetime = new Timestamp(valueMeta.getDate(id).getTime());
                result = datetime.toString();
            } else {
                Object value = this.getValue(valueMeta, id);
                if (value != null) {
                    result = value.toString();
                }
            }
        }
        return result;
    }
}

