/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jsr94.rulesource;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import javax.rules.admin.RuleExecutionSetRegisterException;
import org.springframework.core.io.Resource;
import org.springmodules.jsr94.rulesource.AbstractRuleSource;

public class DefaultRuleSource
extends AbstractRuleSource {
    private Resource source;
    private String bindUri;
    private Map providerProperties;
    private Map rulesetProperties;
    private Map registrationProperties;

    protected void registerRuleExecutionSets() throws RuleExecutionSetCreateException, RemoteException, IOException, RuleExecutionSetRegisterException {
        RuleExecutionSet ruleExecutionSet = this.ruleAdministrator.getLocalRuleExecutionSetProvider(this.providerProperties).createRuleExecutionSet(this.source.getInputStream(), this.rulesetProperties);
        if (this.bindUri == null) {
            logger.info((Object)"Using RuleExecutionSet().getName() as bindUri");
            this.bindUri = ruleExecutionSet.getName();
        }
        this.ruleAdministrator.registerRuleExecutionSet(this.bindUri, ruleExecutionSet, this.registrationProperties);
    }

    protected void initRuleSource() throws Exception {
        if (this.source == null) {
            throw new IllegalArgumentException("Must set source on " + this.getClass().getName());
        }
    }

    public final void setBindUri(String bindUri) {
        this.bindUri = bindUri;
    }

    public final void setSource(Resource source) {
        this.source = source;
    }

    public final void setProviderProperties(Map providerProperties) {
        this.providerProperties = providerProperties;
    }

    public final void setRegistrationProperties(Map registrationProperties) {
        this.registrationProperties = registrationProperties;
    }

    public final void setRulesetProperties(Map rulesetProperties) {
        this.rulesetProperties = rulesetProperties;
    }
}

