/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.caching;

import java.lang.reflect.Method;
import java.util.Properties;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springmodules.cache.EntryRetrievalException;
import org.springmodules.cache.interceptor.caching.Cached;
import org.springmodules.cache.interceptor.caching.CachingAspectSupport;
import org.springmodules.cache.interceptor.caching.CachingAttributeSource;
import org.springmodules.cache.interceptor.caching.EntryStoredListener;
import org.springmodules.cache.interceptor.caching.NameMatchCachingAttributeSource;
import org.springmodules.cache.key.CacheKey;
import org.springmodules.cache.key.CacheKeyGenerator;
import org.springmodules.cache.key.HashCodeCacheKeyGenerator;
import org.springmodules.cache.provider.CacheProviderFacade;

public class CachingInterceptor
extends CachingAspectSupport
implements MethodInterceptor,
InitializingBean {
    private static Log logger = LogFactory.getLog((Class)(class$org$springmodules$cache$interceptor$caching$CachingInterceptor == null ? (class$org$springmodules$cache$interceptor$caching$CachingInterceptor = CachingInterceptor.class$("org.springmodules.cache.interceptor.caching.CachingInterceptor")) : class$org$springmodules$cache$interceptor$caching$CachingInterceptor));
    private CacheProviderFacade cacheProviderFacade;
    static /* synthetic */ Class class$org$springmodules$cache$interceptor$caching$CachingInterceptor;

    public void afterPropertiesSet() {
        CacheKeyGenerator cacheKeyGenerator = super.getCacheKeyGenerator();
        if (cacheKeyGenerator == null) {
            cacheKeyGenerator = new HashCodeCacheKeyGenerator(true);
            super.setCacheKeyGenerator(cacheKeyGenerator);
        }
    }

    protected final Cached getCachingAttribute(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Object thisObject = methodInvocation.getThis();
        Class<?> targetClass = thisObject != null ? thisObject.getClass() : null;
        CachingAttributeSource attributeSource = super.getCachingAttributeSource();
        Cached attribute = attributeSource.getCachingAttribute(method, targetClass);
        return attribute;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object cachedObject = null;
        Cached cachingAttribute = this.getCachingAttribute(methodInvocation);
        if (cachingAttribute == null) {
            return methodInvocation.proceed();
        }
        String cacheProfileId = cachingAttribute.getCacheProfileId();
        CacheKeyGenerator cacheKeyGenerator = super.getCacheKeyGenerator();
        CacheKey cacheKey = cacheKeyGenerator.generateKey(methodInvocation);
        try {
            cachedObject = this.cacheProviderFacade.getFromCache(cacheKey, cacheProfileId);
        }
        catch (EntryRetrievalException entryRetrievalException) {
            if (!logger.isErrorEnabled()) return methodInvocation.proceed();
            String message = "Exception thrown when retrieving an entry from the cache";
            logger.error((Object)message, (Throwable)entryRetrievalException);
            return methodInvocation.proceed();
        }
        if (null != cachedObject) {
            if (CachingAspectSupport.NULL_ENTRY != cachedObject) return cachedObject;
            return null;
        }
        logger.debug((Object)"Method 'invoke(..)'. Object not found in the cache");
        Throwable exceptionThrowByProceed = null;
        try {
            cachedObject = methodInvocation.proceed();
        }
        catch (Throwable throwable) {
            if (logger.isErrorEnabled()) {
                String message = "Exception thrown when executing 'MethodInvocation.proceed()'";
                logger.error((Object)message, throwable);
            }
            exceptionThrowByProceed = throwable;
        }
        if (null != exceptionThrowByProceed) {
            this.cacheProviderFacade.cancelCacheUpdate(cacheKey);
            throw exceptionThrowByProceed;
        }
        if (null == cachedObject) {
            this.cacheProviderFacade.putInCache(cacheKey, cacheProfileId, CachingAspectSupport.NULL_ENTRY);
        } else {
            this.cacheProviderFacade.putInCache(cacheKey, cacheProfileId, cachedObject);
        }
        EntryStoredListener listener = super.getEntryStoredListener();
        if (listener == null) return cachedObject;
        listener.onEntryAdd(cacheKey, cachedObject);
        return cachedObject;
    }

    public final void setCacheProviderFacade(CacheProviderFacade cacheProviderFacade) {
        this.cacheProviderFacade = cacheProviderFacade;
    }

    public final void setCachingAttributes(Properties cachingAttributes) {
        NameMatchCachingAttributeSource attributeSource = new NameMatchCachingAttributeSource();
        attributeSource.setProperties(cachingAttributes);
        super.setCachingAttributeSource(attributeSource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

