/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.caching;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.springmodules.cache.CacheAttribute;
import org.springmodules.cache.interceptor.AbstractSingleMetadataCacheAttributeSource;
import org.springmodules.cache.interceptor.caching.Cached;
import org.springmodules.cache.interceptor.caching.CachingAttributeSource;

public abstract class AbstractCachingAttributeSource
extends AbstractSingleMetadataCacheAttributeSource
implements CachingAttributeSource {
    protected CacheAttribute findAttribute(Collection attributes) {
        CacheAttribute attribute = null;
        if (attributes != null && !attributes.isEmpty()) {
            Iterator attributeIterator = attributes.iterator();
            while (attributeIterator.hasNext() && null == attribute) {
                Object object = attributeIterator.next();
                if (!(object instanceof Cached)) continue;
                attribute = (CacheAttribute)object;
            }
        }
        return attribute;
    }

    public final Cached getCachingAttribute(Method method, Class targetClass) {
        Cached attribute = null;
        boolean cacheable = this.isCacheable(method);
        if (cacheable) {
            attribute = (Cached)super.getAttribute(method, targetClass);
        }
        return attribute;
    }

    protected final boolean isCacheable(Method method) {
        boolean cacheable = true;
        Class<?> returnType = method.getReturnType();
        if ("void".equalsIgnoreCase(returnType.getName())) {
            cacheable = false;
        }
        return cacheable;
    }
}

