/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class AbstractCacheEntry
implements Serializable {
    public static final int INDEFINITE_EXPIRY = -1;
    private static final byte NOT_YET = -1;
    private Object content;
    private long lastUpdate;
    private int refreshPeriod;

    public AbstractCacheEntry() {
        this.setLastUpdate(-1L);
    }

    public boolean equals(Object obj) {
        boolean equals = true;
        if (null == obj || !(obj instanceof AbstractCacheEntry)) {
            equals = false;
        } else if (this != obj) {
            AbstractCacheEntry entry = (AbstractCacheEntry)obj;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append(this.getContent(), entry.getContent());
            equalsBuilder.append(this.getLastUpdate(), entry.getLastUpdate());
            equalsBuilder.append(this.getRefreshPeriod(), entry.getRefreshPeriod());
            equals = equalsBuilder.isEquals();
        }
        return equals;
    }

    public final Object getContent() {
        return this.content;
    }

    public final long getLastUpdate() {
        return this.lastUpdate;
    }

    public final int getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(5, 11);
        hashCodeBuilder.append(this.getContent());
        hashCodeBuilder.append(this.getLastUpdate());
        hashCodeBuilder.append(this.getRefreshPeriod());
        int hashCode = hashCodeBuilder.toHashCode();
        return hashCode;
    }

    public final boolean needsRefresh() {
        boolean stale;
        if (this.lastUpdate == -1L) {
            stale = true;
        } else if (this.refreshPeriod == -1) {
            stale = false;
        } else if (this.refreshPeriod == 0) {
            stale = true;
        } else {
            long currentTimeMillis = System.currentTimeMillis();
            long currentLiveTime = this.lastUpdate + (long)this.refreshPeriod * 1000L;
            stale = this.refreshPeriod > 0 && currentTimeMillis >= currentLiveTime;
        }
        return stale;
    }

    public final void setContent(Object content) {
        this.content = content;
        this.setLastUpdate(System.currentTimeMillis());
    }

    public final void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public final void setRefreshPeriod(int refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
    }
}

