/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openvpms.etl.tools.doc.DelegatingLoaderListener;
import org.openvpms.etl.tools.doc.LoaderListener;

public class FileLoaderListener
extends DelegatingLoaderListener {
    private final Map<File, Long> loaded = new LinkedHashMap<File, Long>();
    private final Map<File, Long> alreadyLoaded = new LinkedHashMap<File, Long>();
    private final Map<File, Long> missingAct = new LinkedHashMap<File, Long>();
    private final Map<File, String> errors = new LinkedHashMap<File, String>();

    public FileLoaderListener(LoaderListener listener) {
        super(listener);
    }

    public Map<File, Long> getLoadedFiles() {
        return this.loaded;
    }

    public Map<File, Long> getAlreadyLoadedFiles() {
        return this.alreadyLoaded;
    }

    public Map<File, Long> getMissingActFiles() {
        return this.missingAct;
    }

    public Map<File, String> getErrorFiles() {
        return this.errors;
    }

    @Override
    public void loaded(File file, long id, File target) {
        super.loaded(file, id, target);
        this.loaded.put(target, id);
    }

    @Override
    public void alreadyLoaded(File file, long id, File target) {
        super.alreadyLoaded(file, id, target);
        this.alreadyLoaded.put(target, id);
    }

    @Override
    public void missingAct(File file, long id, File target) {
        super.missingAct(file, id, target);
        this.missingAct.put(target, id);
    }

    @Override
    public void error(File file, Throwable exception, File target) {
        super.error(file, exception, target);
        this.errors.put(target, exception.getMessage());
    }

    @Override
    public void error(File file, String message, File target) {
        super.error(file, message, target);
        this.errors.put(target, message);
    }
}

