/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.openvpms.etl.load.Mapping;
import org.xml.sax.ContentHandler;

public class Mappings
implements Serializable {
    private String connection;
    private String idColumn;
    private List<Mapping> mappingList = new ArrayList<Mapping>();
    private boolean generateLookups = true;
    private boolean _hasgenerateLookups;
    private boolean skipProcessed = true;
    private boolean _hasskipProcessed;
    private long batchSize = 1000L;
    private boolean _hasbatchSize;

    public void addMapping(Mapping vMapping) throws IndexOutOfBoundsException {
        this.mappingList.add(vMapping);
    }

    public void addMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        this.mappingList.add(index, vMapping);
    }

    public void deleteBatchSize() {
        this._hasbatchSize = false;
    }

    public void deleteGenerateLookups() {
        this._hasgenerateLookups = false;
    }

    public void deleteSkipProcessed() {
        this._hasskipProcessed = false;
    }

    public Enumeration<? extends Mapping> enumerateMapping() {
        return Collections.enumeration(this.mappingList);
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public String getConnection() {
        return this.connection;
    }

    public boolean getGenerateLookups() {
        return this.generateLookups;
    }

    public String getIdColumn() {
        return this.idColumn;
    }

    public Mapping getMapping(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.mappingList.size()) {
            throw new IndexOutOfBoundsException("getMapping: Index value '" + index + "' not in range [0.." + (this.mappingList.size() - 1) + "]");
        }
        return this.mappingList.get(index);
    }

    public Mapping[] getMapping() {
        Mapping[] array = new Mapping[]{};
        return this.mappingList.toArray(array);
    }

    public int getMappingCount() {
        return this.mappingList.size();
    }

    public boolean getSkipProcessed() {
        return this.skipProcessed;
    }

    public boolean hasBatchSize() {
        return this._hasbatchSize;
    }

    public boolean hasGenerateLookups() {
        return this._hasgenerateLookups;
    }

    public boolean hasSkipProcessed() {
        return this._hasskipProcessed;
    }

    public boolean isGenerateLookups() {
        return this.generateLookups;
    }

    public boolean isSkipProcessed() {
        return this.skipProcessed;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Mapping> iterateMapping() {
        return this.mappingList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllMapping() {
        this.mappingList.clear();
    }

    public boolean removeMapping(Mapping vMapping) {
        boolean removed = this.mappingList.remove(vMapping);
        return removed;
    }

    public Mapping removeMappingAt(int index) {
        Mapping obj = this.mappingList.remove(index);
        return obj;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
        this._hasbatchSize = true;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public void setGenerateLookups(boolean generateLookups) {
        this.generateLookups = generateLookups;
        this._hasgenerateLookups = true;
    }

    public void setIdColumn(String idColumn) {
        this.idColumn = idColumn;
    }

    public void setMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.mappingList.size()) {
            throw new IndexOutOfBoundsException("setMapping: Index value '" + index + "' not in range [0.." + (this.mappingList.size() - 1) + "]");
        }
        this.mappingList.set(index, vMapping);
    }

    public void setMapping(Mapping[] vMappingArray) {
        this.mappingList.clear();
        for (int i = 0; i < vMappingArray.length; ++i) {
            this.mappingList.add(vMappingArray[i]);
        }
    }

    public void setSkipProcessed(boolean skipProcessed) {
        this.skipProcessed = skipProcessed;
        this._hasskipProcessed = true;
    }

    public static Mappings unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Mappings)Unmarshaller.unmarshal(Mappings.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

