/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.query.criteria.Subquery;
import org.openvpms.component.system.common.query.criteria.Context;
import org.openvpms.component.system.common.query.criteria.PredicateImpl;
import org.openvpms.component.system.common.query.criteria.RootImpl;
import org.openvpms.component.system.common.query.criteria.SubqueryImpl;

public class CriteriaQueryImpl<T>
implements CriteriaQuery<T> {
    private final Class<T> resultType;
    private final Context context;
    private Selection<? super T> selection;
    private Selection<?>[] selections;
    private boolean distinct;
    private List<RootImpl<? extends IMObject>> roots = new ArrayList<RootImpl<? extends IMObject>>();
    private List<SubqueryImpl<?>> subqueries = new ArrayList();
    private Expression<Boolean> where;
    private List<Expression<?>> groupBy;
    private Expression<Boolean> having;
    private List<Order> orderBy;

    public CriteriaQueryImpl(Class<T> resultType, Context context) {
        this.resultType = resultType;
        this.context = context;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public CriteriaQuery<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public CriteriaQuery<T> select(Selection<? super T> selection) {
        this.selection = selection;
        this.selections = null;
        return this;
    }

    public CriteriaQuery<T> multiselect(Selection<?> ... selections) {
        this.selections = selections;
        this.selection = null;
        return this;
    }

    public Selection<? super T> getSelection() {
        return this.selection;
    }

    public Selection<?>[] getMultiselect() {
        return this.selections;
    }

    public <X extends IMObject> Root<X> from(Class<X> type, String ... archetypes) {
        RootImpl<X> root = new RootImpl<X>(this.context.getType(type, archetypes), this.context);
        this.roots.add(root);
        return root;
    }

    public <X extends IMObject> Root<X> from(Class<X> type, Collection<String> archetypes) {
        return this.from(type, archetypes.toArray(new String[0]));
    }

    public List<RootImpl<? extends IMObject>> getRoots() {
        return this.roots;
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        SubqueryImpl<U> subquery = new SubqueryImpl<U>(type, this.context);
        this.subqueries.add(subquery);
        return subquery;
    }

    public List<SubqueryImpl<?>> getSubqueries() {
        return this.subqueries;
    }

    public CriteriaQuery<T> where(Expression<Boolean> expression) {
        this.where = expression;
        return this;
    }

    public CriteriaQuery<T> where(Predicate ... predicates) {
        if (predicates.length == 1) {
            this.where = predicates[0];
        } else {
            this.where(Arrays.asList(predicates));
        }
        return this;
    }

    public CriteriaQuery<T> where(List<Predicate> predicates) {
        this.where = new PredicateImpl(this.context, new ArrayList<Predicate>(predicates), Predicate.BooleanOperator.AND);
        return this;
    }

    public Expression<Boolean> getWhere() {
        return this.where;
    }

    public CriteriaQuery<T> groupBy(Expression<?> ... grouping) {
        return this.groupBy(Arrays.asList(grouping));
    }

    public CriteriaQuery<T> groupBy(List<Expression<?>> grouping) {
        this.groupBy = grouping;
        return this;
    }

    public List<Expression<?>> getGroupBy() {
        return this.groupBy;
    }

    public CriteriaQuery<T> having(Expression<Boolean> expression) {
        this.having = expression;
        return this;
    }

    public CriteriaQuery<T> having(Predicate ... predicates) {
        this.having = predicates.length == 1 ? predicates[0] : new PredicateImpl(this.context, Arrays.asList(predicates), Predicate.BooleanOperator.AND);
        return this;
    }

    public Expression<Boolean> getHaving() {
        return this.having;
    }

    public CriteriaQuery<T> orderBy(Order ... order) {
        return this.orderBy(Arrays.asList(order));
    }

    public CriteriaQuery<T> orderBy(List<Order> order) {
        this.orderBy = order;
        return this;
    }

    public List<Order> getOrderBy() {
        return this.orderBy;
    }
}

