/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.system.common.query.AbstractArchetypeQuery;

public class NamedQuery
extends AbstractArchetypeQuery {
    private String query;
    private Collection<String> names;
    private Map<String, Object> parameters;

    public NamedQuery(String query) {
        this(query, (Collection<String>)null);
    }

    public NamedQuery(String query, Collection<String> names) {
        this(query, names, null);
    }

    public NamedQuery(String query, String ... names) {
        this(query, names.length != 0 ? Arrays.asList(names) : null, null);
    }

    public NamedQuery(String query, Collection<String> names, Map<String, Object> parameters) {
        this.query = query;
        this.names = names != null && !names.isEmpty() ? names : null;
        this.parameters = parameters != null ? parameters : new HashMap<String, Object>();
    }

    public String getQuery() {
        return this.query;
    }

    public Collection<String> getNames() {
        return this.names;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NamedQuery)) {
            return false;
        }
        NamedQuery rhs = (NamedQuery)obj;
        return new EqualsBuilder().appendSuper(super.equals(rhs)).append((Object)this.query, (Object)rhs.query).append(this.names, rhs.names).append(this.parameters, rhs.parameters).isEquals();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("query", (Object)this.query).append("names", this.names).append("parameters", this.parameters).toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NamedQuery copy = (NamedQuery)super.clone();
        copy.names = new ArrayList<String>(this.names);
        if (this.parameters != null) {
            copy.parameters = new HashMap<String, Object>(this.parameters);
        }
        return copy;
    }
}

